/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageBuilderStreamingUrlResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, CreateImageBuilderStreamingUrlResponse> {
    private static final SdkField<String> STREAMING_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamingURL").getter(CreateImageBuilderStreamingUrlResponse.getter(CreateImageBuilderStreamingUrlResponse::streamingURL)).setter(CreateImageBuilderStreamingUrlResponse.setter(Builder::streamingURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingURL").build()}).build();
    private static final SdkField<Instant> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Expires").getter(CreateImageBuilderStreamingUrlResponse.getter(CreateImageBuilderStreamingUrlResponse::expires)).setter(CreateImageBuilderStreamingUrlResponse.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expires").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_URL_FIELD, EXPIRES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImageBuilderStreamingUrlResponse.memberNameToFieldInitializer();
    private final String streamingURL;
    private final Instant expires;

    private CreateImageBuilderStreamingUrlResponse(BuilderImpl builder) {
        super(builder);
        this.streamingURL = builder.streamingURL;
        this.expires = builder.expires;
    }

    public final String streamingURL() {
        return this.streamingURL;
    }

    public final Instant expires() {
        return this.expires;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderStreamingUrlResponse)) {
            return false;
        }
        CreateImageBuilderStreamingUrlResponse other = (CreateImageBuilderStreamingUrlResponse)((Object)obj);
        return Objects.equals(this.streamingURL(), other.streamingURL()) && Objects.equals(this.expires(), other.expires());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageBuilderStreamingUrlResponse").add("StreamingURL", (Object)this.streamingURL()).add("Expires", (Object)this.expires()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingURL": {
                return Optional.ofNullable(clazz.cast(this.streamingURL()));
            }
            case "Expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamingURL", STREAMING_URL_FIELD);
        map.put("Expires", EXPIRES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImageBuilderStreamingUrlResponse, T> g) {
        return obj -> g.apply((CreateImageBuilderStreamingUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private String streamingURL;
        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderStreamingUrlResponse model) {
            super(model);
            this.streamingURL(model.streamingURL);
            this.expires(model.expires);
        }

        public final String getStreamingURL() {
            return this.streamingURL;
        }

        public final void setStreamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
        }

        @Override
        public final Builder streamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
            return this;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public CreateImageBuilderStreamingUrlResponse build() {
            return new CreateImageBuilderStreamingUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageBuilderStreamingUrlResponse> {
        public Builder streamingURL(String var1);

        public Builder expires(Instant var1);
    }
}

