/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SoftwareDeploymentStatus {
    STAGED_FOR_INSTALLATION("STAGED_FOR_INSTALLATION"),
    PENDING_INSTALLATION("PENDING_INSTALLATION"),
    INSTALLED("INSTALLED"),
    STAGED_FOR_UNINSTALLATION("STAGED_FOR_UNINSTALLATION"),
    PENDING_UNINSTALLATION("PENDING_UNINSTALLATION"),
    FAILED_TO_INSTALL("FAILED_TO_INSTALL"),
    FAILED_TO_UNINSTALL("FAILED_TO_UNINSTALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SoftwareDeploymentStatus> VALUE_MAP;
    private final String value;

    private SoftwareDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SoftwareDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SoftwareDeploymentStatus> knownValues() {
        EnumSet<SoftwareDeploymentStatus> knownValues = EnumSet.allOf(SoftwareDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SoftwareDeploymentStatus.class, SoftwareDeploymentStatus::toString);
    }
}

