/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageAction {
    SUPPRESS("SUPPRESS"),
    RESEND("RESEND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageAction> VALUE_MAP;
    private final String value;

    private MessageAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageAction> knownValues() {
        EnumSet<MessageAction> knownValues = EnumSet.allOf(MessageAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageAction.class, MessageAction::toString);
    }
}

