/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentSoftwareVersion {
    CURRENT_LATEST("CURRENT_LATEST"),
    ALWAYS_LATEST("ALWAYS_LATEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentSoftwareVersion> VALUE_MAP;
    private final String value;

    private AgentSoftwareVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentSoftwareVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentSoftwareVersion> knownValues() {
        EnumSet<AgentSoftwareVersion> knownValues = EnumSet.allOf(AgentSoftwareVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentSoftwareVersion.class, AgentSoftwareVersion::toString);
    }
}

