/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.Action;
import software.amazon.awssdk.services.appstream.model.Permission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSetting> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(UserSetting.getter(UserSetting::actionAsString)).setter(UserSetting.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(UserSetting.getter(UserSetting::permissionAsString)).setter(UserSetting.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").build()}).build();
    private static final SdkField<Integer> MAXIMUM_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumLength").getter(UserSetting.getter(UserSetting::maximumLength)).setter(UserSetting.setter(Builder::maximumLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PERMISSION_FIELD, MAXIMUM_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String permission;
    private final Integer maximumLength;

    private UserSetting(BuilderImpl builder) {
        this.action = builder.action;
        this.permission = builder.permission;
        this.maximumLength = builder.maximumLength;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final Integer maximumLength() {
        return this.maximumLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSetting)) {
            return false;
        }
        UserSetting other = (UserSetting)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.maximumLength(), other.maximumLength());
    }

    public final String toString() {
        return ToString.builder((String)"UserSetting").add("Action", (Object)this.actionAsString()).add("Permission", (Object)this.permissionAsString()).add("MaximumLength", (Object)this.maximumLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "MaximumLength": {
                return Optional.ofNullable(clazz.cast(this.maximumLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        map.put("MaximumLength", MAXIMUM_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSetting, T> g) {
        return obj -> g.apply((UserSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String permission;
        private Integer maximumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSetting model) {
            this.action(model.action);
            this.permission(model.permission);
            this.maximumLength(model.maximumLength);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Integer getMaximumLength() {
            return this.maximumLength;
        }

        public final void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public UserSetting build() {
            return new UserSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSetting> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder maximumLength(Integer var1);
    }
}

