/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackAttribute {
    STORAGE_CONNECTORS("STORAGE_CONNECTORS"),
    STORAGE_CONNECTOR_HOMEFOLDERS("STORAGE_CONNECTOR_HOMEFOLDERS"),
    STORAGE_CONNECTOR_GOOGLE_DRIVE("STORAGE_CONNECTOR_GOOGLE_DRIVE"),
    STORAGE_CONNECTOR_ONE_DRIVE("STORAGE_CONNECTOR_ONE_DRIVE"),
    REDIRECT_URL("REDIRECT_URL"),
    FEEDBACK_URL("FEEDBACK_URL"),
    THEME_NAME("THEME_NAME"),
    USER_SETTINGS("USER_SETTINGS"),
    EMBED_HOST_DOMAINS("EMBED_HOST_DOMAINS"),
    IAM_ROLE_ARN("IAM_ROLE_ARN"),
    ACCESS_ENDPOINTS("ACCESS_ENDPOINTS"),
    STREAMING_EXPERIENCE_SETTINGS("STREAMING_EXPERIENCE_SETTINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackAttribute> VALUE_MAP;
    private final String value;

    private StackAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackAttribute> knownValues() {
        EnumSet<StackAttribute> knownValues = EnumSet.allOf(StackAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackAttribute.class, StackAttribute::toString);
    }
}

