/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Action {
    CLIPBOARD_COPY_FROM_LOCAL_DEVICE("CLIPBOARD_COPY_FROM_LOCAL_DEVICE"),
    CLIPBOARD_COPY_TO_LOCAL_DEVICE("CLIPBOARD_COPY_TO_LOCAL_DEVICE"),
    FILE_UPLOAD("FILE_UPLOAD"),
    FILE_DOWNLOAD("FILE_DOWNLOAD"),
    PRINTING_TO_LOCAL_DEVICE("PRINTING_TO_LOCAL_DEVICE"),
    DOMAIN_PASSWORD_SIGNIN("DOMAIN_PASSWORD_SIGNIN"),
    DOMAIN_SMART_CARD_SIGNIN("DOMAIN_SMART_CARD_SIGNIN"),
    AUTO_TIME_ZONE_REDIRECTION("AUTO_TIME_ZONE_REDIRECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Action> VALUE_MAP;
    private final String value;

    private Action(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Action fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Action> knownValues() {
        EnumSet<Action> knownValues = EnumSet.allOf(Action.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Action.class, Action::toString);
    }
}

