/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcIngressConnectionRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, UpdateVpcIngressConnectionRequest> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcIngressConnectionArn").getter(UpdateVpcIngressConnectionRequest.getter(UpdateVpcIngressConnectionRequest::vpcIngressConnectionArn)).setter(UpdateVpcIngressConnectionRequest.setter(Builder::vpcIngressConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build()}).build();
    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration").getter(UpdateVpcIngressConnectionRequest.getter(UpdateVpcIngressConnectionRequest::ingressVpcConfiguration)).setter(UpdateVpcIngressConnectionRequest.setter(Builder::ingressVpcConfiguration)).constructor(IngressVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_INGRESS_CONNECTION_ARN_FIELD, INGRESS_VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateVpcIngressConnectionRequest.memberNameToFieldInitializer();
    private final String vpcIngressConnectionArn;
    private final IngressVpcConfiguration ingressVpcConfiguration;

    private UpdateVpcIngressConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
    }

    public final String vpcIngressConnectionArn() {
        return this.vpcIngressConnectionArn;
    }

    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return this.ingressVpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressVpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcIngressConnectionRequest)) {
            return false;
        }
        UpdateVpcIngressConnectionRequest other = (UpdateVpcIngressConnectionRequest)((Object)obj);
        return Objects.equals(this.vpcIngressConnectionArn(), other.vpcIngressConnectionArn()) && Objects.equals(this.ingressVpcConfiguration(), other.ingressVpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVpcIngressConnectionRequest").add("VpcIngressConnectionArn", (Object)this.vpcIngressConnectionArn()).add("IngressVpcConfiguration", (Object)this.ingressVpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcIngressConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcIngressConnectionArn()));
            }
            case "IngressVpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressVpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcIngressConnectionRequest, T> g) {
        return obj -> g.apply((UpdateVpcIngressConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String vpcIngressConnectionArn;
        private IngressVpcConfiguration ingressVpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcIngressConnectionRequest model) {
            super(model);
            this.vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            this.ingressVpcConfiguration(model.ingressVpcConfiguration);
        }

        public final String getVpcIngressConnectionArn() {
            return this.vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return this.ingressVpcConfiguration != null ? this.ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcIngressConnectionRequest build() {
            return new UpdateVpcIngressConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcIngressConnectionRequest> {
        public Builder vpcIngressConnectionArn(String var1);

        public Builder ingressVpcConfiguration(IngressVpcConfiguration var1);

        default public Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return this.ingressVpcConfiguration((IngressVpcConfiguration)((IngressVpcConfiguration.Builder)IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

