/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageRepositoryType {
    ECR("ECR"),
    ECR_PUBLIC("ECR_PUBLIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageRepositoryType> VALUE_MAP;
    private final String value;

    private ImageRepositoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageRepositoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageRepositoryType> knownValues() {
        EnumSet<ImageRepositoryType> knownValues = EnumSet.allOf(ImageRepositoryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageRepositoryType.class, ImageRepositoryType::toString);
    }
}

