/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues;
import software.amazon.awssdk.services.apprunner.model.ConfigurationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeConfiguration> {
    private static final SdkField<String> CONFIGURATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSource").getter(CodeConfiguration.getter(CodeConfiguration::configurationSourceAsString)).setter(CodeConfiguration.setter(Builder::configurationSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSource").build()}).build();
    private static final SdkField<CodeConfigurationValues> CODE_CONFIGURATION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeConfigurationValues").getter(CodeConfiguration.getter(CodeConfiguration::codeConfigurationValues)).setter(CodeConfiguration.setter(Builder::codeConfigurationValues)).constructor(CodeConfigurationValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeConfigurationValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SOURCE_FIELD, CODE_CONFIGURATION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configurationSource;
    private final CodeConfigurationValues codeConfigurationValues;

    private CodeConfiguration(BuilderImpl builder) {
        this.configurationSource = builder.configurationSource;
        this.codeConfigurationValues = builder.codeConfigurationValues;
    }

    public final ConfigurationSource configurationSource() {
        return ConfigurationSource.fromValue(this.configurationSource);
    }

    public final String configurationSourceAsString() {
        return this.configurationSource;
    }

    public final CodeConfigurationValues codeConfigurationValues() {
        return this.codeConfigurationValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeConfigurationValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfiguration)) {
            return false;
        }
        CodeConfiguration other = (CodeConfiguration)obj;
        return Objects.equals(this.configurationSourceAsString(), other.configurationSourceAsString()) && Objects.equals(this.codeConfigurationValues(), other.codeConfigurationValues());
    }

    public final String toString() {
        return ToString.builder((String)"CodeConfiguration").add("ConfigurationSource", (Object)this.configurationSourceAsString()).add("CodeConfigurationValues", (Object)this.codeConfigurationValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSource": {
                return Optional.ofNullable(clazz.cast(this.configurationSourceAsString()));
            }
            case "CodeConfigurationValues": {
                return Optional.ofNullable(clazz.cast(this.codeConfigurationValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationSource", CONFIGURATION_SOURCE_FIELD);
        map.put("CodeConfigurationValues", CODE_CONFIGURATION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeConfiguration, T> g) {
        return obj -> g.apply((CodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationSource;
        private CodeConfigurationValues codeConfigurationValues;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeConfiguration model) {
            this.configurationSource(model.configurationSource);
            this.codeConfigurationValues(model.codeConfigurationValues);
        }

        public final String getConfigurationSource() {
            return this.configurationSource;
        }

        public final void setConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
        }

        @Override
        public final Builder configurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        @Override
        public final Builder configurationSource(ConfigurationSource configurationSource) {
            this.configurationSource(configurationSource == null ? null : configurationSource.toString());
            return this;
        }

        public final CodeConfigurationValues.Builder getCodeConfigurationValues() {
            return this.codeConfigurationValues != null ? this.codeConfigurationValues.toBuilder() : null;
        }

        public final void setCodeConfigurationValues(CodeConfigurationValues.BuilderImpl codeConfigurationValues) {
            this.codeConfigurationValues = codeConfigurationValues != null ? codeConfigurationValues.build() : null;
        }

        @Override
        public final Builder codeConfigurationValues(CodeConfigurationValues codeConfigurationValues) {
            this.codeConfigurationValues = codeConfigurationValues;
            return this;
        }

        public CodeConfiguration build() {
            return new CodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeConfiguration> {
        public Builder configurationSource(String var1);

        public Builder configurationSource(ConfigurationSource var1);

        public Builder codeConfigurationValues(CodeConfigurationValues var1);

        default public Builder codeConfigurationValues(Consumer<CodeConfigurationValues.Builder> codeConfigurationValues) {
            return this.codeConfigurationValues((CodeConfigurationValues)((CodeConfigurationValues.Builder)CodeConfigurationValues.builder().applyMutation(codeConfigurationValues)).build());
        }
    }
}

