/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListServicesRequest;
import software.amazon.awssdk.services.apprunner.model.ListServicesResponse;

public class ListServicesIterable
implements SdkIterable<ListServicesResponse> {
    private final AppRunnerClient client;
    private final ListServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicesIterable(AppRunnerClient client, ListServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServicesResponseFetcher();
    }

    public Iterator<ListServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServicesResponseFetcher
    implements SyncPageFetcher<ListServicesResponse> {
        private ListServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicesResponse nextPage(ListServicesResponse previousPage) {
            if (previousPage == null) {
                return ListServicesIterable.this.client.listServices(ListServicesIterable.this.firstRequest);
            }
            return ListServicesIterable.this.client.listServices((ListServicesRequest)((Object)ListServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

