/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceStatesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceStatesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceState;

public class ListServiceStatesPublisher
implements SdkPublisher<ListServiceStatesResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceStatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceStatesPublisher(ApplicationSignalsAsyncClient client, ListServiceStatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceStatesPublisher(ApplicationSignalsAsyncClient client, ListServiceStatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceStatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceStatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceState> serviceStates() {
        Function<ListServiceStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceStates() != null) {
                return response.serviceStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceStatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceStatesResponseFetcher
    implements AsyncPageFetcher<ListServiceStatesResponse> {
        private ListServiceStatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceStatesResponse> nextPage(ListServiceStatesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceStatesPublisher.this.client.listServiceStates(ListServiceStatesPublisher.this.firstRequest);
            }
            return ListServiceStatesPublisher.this.client.listServiceStates((ListServiceStatesRequest)((Object)ListServiceStatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

