/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceStatesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceStatesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceState;

public class ListServiceStatesIterable
implements SdkIterable<ListServiceStatesResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceStatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceStatesIterable(ApplicationSignalsClient client, ListServiceStatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceStatesResponseFetcher();
    }

    public Iterator<ListServiceStatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceState> serviceStates() {
        Function<ListServiceStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceStates() != null) {
                return response.serviceStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceStatesResponseFetcher
    implements SyncPageFetcher<ListServiceStatesResponse> {
        private ListServiceStatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceStatesResponse nextPage(ListServiceStatesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceStatesIterable.this.client.listServiceStates(ListServiceStatesIterable.this.firstRequest);
            }
            return ListServiceStatesIterable.this.client.listServiceStates((ListServiceStatesRequest)((Object)ListServiceStatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

