/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceOperation;
import software.amazon.awssdk.services.applicationsignals.model.ServiceOperationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceOperationsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListServiceOperationsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListServiceOperationsResponse.getter(ListServiceOperationsResponse::startTime)).setter(ListServiceOperationsResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListServiceOperationsResponse.getter(ListServiceOperationsResponse::endTime)).setter(ListServiceOperationsResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<ServiceOperation>> SERVICE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceOperations").getter(ListServiceOperationsResponse.getter(ListServiceOperationsResponse::serviceOperations)).setter(ListServiceOperationsResponse.setter(Builder::serviceOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceOperationsResponse.getter(ListServiceOperationsResponse::nextToken)).setter(ListServiceOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, SERVICE_OPERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceOperationsResponse.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final List<ServiceOperation> serviceOperations;
    private final String nextToken;

    private ListServiceOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceOperations = builder.serviceOperations;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasServiceOperations() {
        return this.serviceOperations != null && !(this.serviceOperations instanceof SdkAutoConstructList);
    }

    public final List<ServiceOperation> serviceOperations() {
        return this.serviceOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceOperations() ? this.serviceOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceOperationsResponse)) {
            return false;
        }
        ListServiceOperationsResponse other = (ListServiceOperationsResponse)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasServiceOperations() == other.hasServiceOperations() && Objects.equals(this.serviceOperations(), other.serviceOperations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceOperationsResponse").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ServiceOperations", this.hasServiceOperations() ? this.serviceOperations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ServiceOperations": {
                return Optional.ofNullable(clazz.cast(this.serviceOperations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ServiceOperations", SERVICE_OPERATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceOperationsResponse, T> g) {
        return obj -> g.apply((ListServiceOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<ServiceOperation> serviceOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceOperationsResponse model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.serviceOperations(model.serviceOperations);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ServiceOperation.Builder> getServiceOperations() {
            List<ServiceOperation.Builder> result = ServiceOperationsCopier.copyToBuilder(this.serviceOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceOperations(Collection<ServiceOperation.BuilderImpl> serviceOperations) {
            this.serviceOperations = ServiceOperationsCopier.copyFromBuilder(serviceOperations);
        }

        @Override
        public final Builder serviceOperations(Collection<ServiceOperation> serviceOperations) {
            this.serviceOperations = ServiceOperationsCopier.copy(serviceOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOperations(ServiceOperation ... serviceOperations) {
            this.serviceOperations(Arrays.asList(serviceOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOperations(Consumer<ServiceOperation.Builder> ... serviceOperations) {
            this.serviceOperations(Stream.of(serviceOperations).map(c -> (ServiceOperation)((ServiceOperation.Builder)ServiceOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceOperationsResponse build() {
            return new ListServiceOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceOperationsResponse> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder serviceOperations(Collection<ServiceOperation> var1);

        public Builder serviceOperations(ServiceOperation ... var1);

        public Builder serviceOperations(Consumer<ServiceOperation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

