/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinition;
import software.amazon.awssdk.services.applicationsignals.model.GroupingAttributeDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupingAttributeDefinitionsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListGroupingAttributeDefinitionsResponse> {
    private static final SdkField<List<GroupingAttributeDefinition>> GROUPING_ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupingAttributeDefinitions").getter(ListGroupingAttributeDefinitionsResponse.getter(ListGroupingAttributeDefinitionsResponse::groupingAttributeDefinitions)).setter(ListGroupingAttributeDefinitionsResponse.setter(Builder::groupingAttributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingAttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupingAttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ListGroupingAttributeDefinitionsResponse.getter(ListGroupingAttributeDefinitionsResponse::updatedAt)).setter(ListGroupingAttributeDefinitionsResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupingAttributeDefinitionsResponse.getter(ListGroupingAttributeDefinitionsResponse::nextToken)).setter(ListGroupingAttributeDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPING_ATTRIBUTE_DEFINITIONS_FIELD, UPDATED_AT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGroupingAttributeDefinitionsResponse.memberNameToFieldInitializer();
    private final List<GroupingAttributeDefinition> groupingAttributeDefinitions;
    private final Instant updatedAt;
    private final String nextToken;

    private ListGroupingAttributeDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.groupingAttributeDefinitions = builder.groupingAttributeDefinitions;
        this.updatedAt = builder.updatedAt;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroupingAttributeDefinitions() {
        return this.groupingAttributeDefinitions != null && !(this.groupingAttributeDefinitions instanceof SdkAutoConstructList);
    }

    public final List<GroupingAttributeDefinition> groupingAttributeDefinitions() {
        return this.groupingAttributeDefinitions;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupingAttributeDefinitions() ? this.groupingAttributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingAttributeDefinitionsResponse)) {
            return false;
        }
        ListGroupingAttributeDefinitionsResponse other = (ListGroupingAttributeDefinitionsResponse)((Object)obj);
        return this.hasGroupingAttributeDefinitions() == other.hasGroupingAttributeDefinitions() && Objects.equals(this.groupingAttributeDefinitions(), other.groupingAttributeDefinitions()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupingAttributeDefinitionsResponse").add("GroupingAttributeDefinitions", this.hasGroupingAttributeDefinitions() ? this.groupingAttributeDefinitions() : null).add("UpdatedAt", (Object)this.updatedAt()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupingAttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.groupingAttributeDefinitions()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupingAttributeDefinitions", GROUPING_ATTRIBUTE_DEFINITIONS_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingAttributeDefinitionsResponse, T> g) {
        return obj -> g.apply((ListGroupingAttributeDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private List<GroupingAttributeDefinition> groupingAttributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingAttributeDefinitionsResponse model) {
            super(model);
            this.groupingAttributeDefinitions(model.groupingAttributeDefinitions);
            this.updatedAt(model.updatedAt);
            this.nextToken(model.nextToken);
        }

        public final List<GroupingAttributeDefinition.Builder> getGroupingAttributeDefinitions() {
            List<GroupingAttributeDefinition.Builder> result = GroupingAttributeDefinitionsCopier.copyToBuilder(this.groupingAttributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingAttributeDefinitions(Collection<GroupingAttributeDefinition.BuilderImpl> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copyFromBuilder(groupingAttributeDefinitions);
        }

        @Override
        public final Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = GroupingAttributeDefinitionsCopier.copy(groupingAttributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(GroupingAttributeDefinition ... groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions(Arrays.asList(groupingAttributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingAttributeDefinitions(Consumer<GroupingAttributeDefinition.Builder> ... groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions(Stream.of(groupingAttributeDefinitions).map(c -> (GroupingAttributeDefinition)((GroupingAttributeDefinition.Builder)GroupingAttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupingAttributeDefinitionsResponse build() {
            return new ListGroupingAttributeDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupingAttributeDefinitionsResponse> {
        public Builder groupingAttributeDefinitions(Collection<GroupingAttributeDefinition> var1);

        public Builder groupingAttributeDefinitions(GroupingAttributeDefinition ... var1);

        public Builder groupingAttributeDefinitions(Consumer<GroupingAttributeDefinition.Builder> ... var1);

        public Builder updatedAt(Instant var1);

        public Builder nextToken(String var1);
    }
}

