/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.ChangeEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(ChangeEvent.getter(ChangeEvent::timestamp)).setter(ChangeEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ChangeEvent.getter(ChangeEvent::accountId)).setter(ChangeEvent.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ChangeEvent.getter(ChangeEvent::region)).setter(ChangeEvent.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Map<String, String>> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Entity").getter(ChangeEvent.getter(ChangeEvent::entity)).setter(ChangeEvent.setter(Builder::entity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeEventType").getter(ChangeEvent.getter(ChangeEvent::changeEventTypeAsString)).setter(ChangeEvent.setter(Builder::changeEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeEventType").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(ChangeEvent.getter(ChangeEvent::eventId)).setter(ChangeEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(ChangeEvent.getter(ChangeEvent::userName)).setter(ChangeEvent.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventName").getter(ChangeEvent.getter(ChangeEvent::eventName)).setter(ChangeEvent.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, ENTITY_FIELD, CHANGE_EVENT_TYPE_FIELD, EVENT_ID_FIELD, USER_NAME_FIELD, EVENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String accountId;
    private final String region;
    private final Map<String, String> entity;
    private final String changeEventType;
    private final String eventId;
    private final String userName;
    private final String eventName;

    private ChangeEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.entity = builder.entity;
        this.changeEventType = builder.changeEventType;
        this.eventId = builder.eventId;
        this.userName = builder.userName;
        this.eventName = builder.eventName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasEntity() {
        return this.entity != null && !(this.entity instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> entity() {
        return this.entity;
    }

    public final ChangeEventType changeEventType() {
        return ChangeEventType.fromValue(this.changeEventType);
    }

    public final String changeEventTypeAsString() {
        return this.changeEventType;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String eventName() {
        return this.eventName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntity() ? this.entity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeEvent)) {
            return false;
        }
        ChangeEvent other = (ChangeEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.region(), other.region()) && this.hasEntity() == other.hasEntity() && Objects.equals(this.entity(), other.entity()) && Objects.equals(this.changeEventTypeAsString(), other.changeEventTypeAsString()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.eventName(), other.eventName());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeEvent").add("Timestamp", (Object)this.timestamp()).add("AccountId", (Object)this.accountId()).add("Region", (Object)this.region()).add("Entity", this.hasEntity() ? this.entity() : null).add("ChangeEventType", (Object)this.changeEventTypeAsString()).add("EventId", (Object)this.eventId()).add("UserName", (Object)this.userName()).add("EventName", (Object)this.eventName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entity()));
            }
            case "ChangeEventType": {
                return Optional.ofNullable(clazz.cast(this.changeEventTypeAsString()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "EventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("Entity", ENTITY_FIELD);
        map.put("ChangeEventType", CHANGE_EVENT_TYPE_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("EventName", EVENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeEvent, T> g) {
        return obj -> g.apply((ChangeEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String accountId;
        private String region;
        private Map<String, String> entity = DefaultSdkAutoConstructMap.getInstance();
        private String changeEventType;
        private String eventId;
        private String userName;
        private String eventName;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeEvent model) {
            this.timestamp(model.timestamp);
            this.accountId(model.accountId);
            this.region(model.region);
            this.entity(model.entity);
            this.changeEventType(model.changeEventType);
            this.eventId(model.eventId);
            this.userName(model.userName);
            this.eventName(model.eventName);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Map<String, String> getEntity() {
            if (this.entity instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.entity;
        }

        public final void setEntity(Map<String, String> entity) {
            this.entity = AttributesCopier.copy(entity);
        }

        @Override
        public final Builder entity(Map<String, String> entity) {
            this.entity = AttributesCopier.copy(entity);
            return this;
        }

        public final String getChangeEventType() {
            return this.changeEventType;
        }

        public final void setChangeEventType(String changeEventType) {
            this.changeEventType = changeEventType;
        }

        @Override
        public final Builder changeEventType(String changeEventType) {
            this.changeEventType = changeEventType;
            return this;
        }

        @Override
        public final Builder changeEventType(ChangeEventType changeEventType) {
            this.changeEventType(changeEventType == null ? null : changeEventType.toString());
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public ChangeEvent build() {
            return new ChangeEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeEvent> {
        public Builder timestamp(Instant var1);

        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder entity(Map<String, String> var1);

        public Builder changeEventType(String var1);

        public Builder changeEventType(ChangeEventType var1);

        public Builder eventId(String var1);

        public Builder userName(String var1);

        public Builder eventName(String var1);
    }
}

