/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.AuditorResult;
import software.amazon.awssdk.services.applicationsignals.model.AuditorResultsCopier;
import software.amazon.awssdk.services.applicationsignals.model.DependencyGraph;
import software.amazon.awssdk.services.applicationsignals.model.MetricGraph;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditFinding> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(AuditFinding.getter(AuditFinding::keyAttributes)).setter(AuditFinding.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AuditorResult>> AUDITOR_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuditorResults").getter(AuditFinding.getter(AuditFinding::auditorResults)).setter(AuditFinding.setter(Builder::auditorResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditorResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditorResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(AuditFinding.getter(AuditFinding::operation)).setter(AuditFinding.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<MetricGraph> METRIC_GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricGraph").getter(AuditFinding.getter(AuditFinding::metricGraph)).setter(AuditFinding.setter(Builder::metricGraph)).constructor(MetricGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGraph").build()}).build();
    private static final SdkField<DependencyGraph> DEPENDENCY_GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DependencyGraph").getter(AuditFinding.getter(AuditFinding::dependencyGraph)).setter(AuditFinding.setter(Builder::dependencyGraph)).constructor(DependencyGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyGraph").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AuditFinding.getter(AuditFinding::type)).setter(AuditFinding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, AUDITOR_RESULTS_FIELD, OPERATION_FIELD, METRIC_GRAPH_FIELD, DEPENDENCY_GRAPH_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> keyAttributes;
    private final List<AuditorResult> auditorResults;
    private final String operation;
    private final MetricGraph metricGraph;
    private final DependencyGraph dependencyGraph;
    private final String type;

    private AuditFinding(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.auditorResults = builder.auditorResults;
        this.operation = builder.operation;
        this.metricGraph = builder.metricGraph;
        this.dependencyGraph = builder.dependencyGraph;
        this.type = builder.type;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final boolean hasAuditorResults() {
        return this.auditorResults != null && !(this.auditorResults instanceof SdkAutoConstructList);
    }

    public final List<AuditorResult> auditorResults() {
        return this.auditorResults;
    }

    public final String operation() {
        return this.operation;
    }

    public final MetricGraph metricGraph() {
        return this.metricGraph;
    }

    public final DependencyGraph dependencyGraph() {
        return this.dependencyGraph;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditorResults() ? this.auditorResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricGraph());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyGraph());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding)obj;
        return this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && this.hasAuditorResults() == other.hasAuditorResults() && Objects.equals(this.auditorResults(), other.auditorResults()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.metricGraph(), other.metricGraph()) && Objects.equals(this.dependencyGraph(), other.dependencyGraph()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AuditFinding").add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("AuditorResults", this.hasAuditorResults() ? this.auditorResults() : null).add("Operation", (Object)this.operation()).add("MetricGraph", (Object)this.metricGraph()).add("DependencyGraph", (Object)this.dependencyGraph()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "AuditorResults": {
                return Optional.ofNullable(clazz.cast(this.auditorResults()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "MetricGraph": {
                return Optional.ofNullable(clazz.cast(this.metricGraph()));
            }
            case "DependencyGraph": {
                return Optional.ofNullable(clazz.cast(this.dependencyGraph()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("AuditorResults", AUDITOR_RESULTS_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("MetricGraph", METRIC_GRAPH_FIELD);
        map.put("DependencyGraph", DEPENDENCY_GRAPH_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditFinding, T> g) {
        return obj -> g.apply((AuditFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<AuditorResult> auditorResults = DefaultSdkAutoConstructList.getInstance();
        private String operation;
        private MetricGraph metricGraph;
        private DependencyGraph dependencyGraph;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditFinding model) {
            this.keyAttributes(model.keyAttributes);
            this.auditorResults(model.auditorResults);
            this.operation(model.operation);
            this.metricGraph(model.metricGraph);
            this.dependencyGraph(model.dependencyGraph);
            this.type(model.type);
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final List<AuditorResult.Builder> getAuditorResults() {
            List<AuditorResult.Builder> result = AuditorResultsCopier.copyToBuilder(this.auditorResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditorResults(Collection<AuditorResult.BuilderImpl> auditorResults) {
            this.auditorResults = AuditorResultsCopier.copyFromBuilder(auditorResults);
        }

        @Override
        public final Builder auditorResults(Collection<AuditorResult> auditorResults) {
            this.auditorResults = AuditorResultsCopier.copy(auditorResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditorResults(AuditorResult ... auditorResults) {
            this.auditorResults(Arrays.asList(auditorResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditorResults(Consumer<AuditorResult.Builder> ... auditorResults) {
            this.auditorResults(Stream.of(auditorResults).map(c -> (AuditorResult)((AuditorResult.Builder)AuditorResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final MetricGraph.Builder getMetricGraph() {
            return this.metricGraph != null ? this.metricGraph.toBuilder() : null;
        }

        public final void setMetricGraph(MetricGraph.BuilderImpl metricGraph) {
            this.metricGraph = metricGraph != null ? metricGraph.build() : null;
        }

        @Override
        public final Builder metricGraph(MetricGraph metricGraph) {
            this.metricGraph = metricGraph;
            return this;
        }

        public final DependencyGraph.Builder getDependencyGraph() {
            return this.dependencyGraph != null ? this.dependencyGraph.toBuilder() : null;
        }

        public final void setDependencyGraph(DependencyGraph.BuilderImpl dependencyGraph) {
            this.dependencyGraph = dependencyGraph != null ? dependencyGraph.build() : null;
        }

        @Override
        public final Builder dependencyGraph(DependencyGraph dependencyGraph) {
            this.dependencyGraph = dependencyGraph;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AuditFinding build() {
            return new AuditFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditFinding> {
        public Builder keyAttributes(Map<String, String> var1);

        public Builder auditorResults(Collection<AuditorResult> var1);

        public Builder auditorResults(AuditorResult ... var1);

        public Builder auditorResults(Consumer<AuditorResult.Builder> ... var1);

        public Builder operation(String var1);

        public Builder metricGraph(MetricGraph var1);

        default public Builder metricGraph(Consumer<MetricGraph.Builder> metricGraph) {
            return this.metricGraph((MetricGraph)((MetricGraph.Builder)MetricGraph.builder().applyMutation(metricGraph)).build());
        }

        public Builder dependencyGraph(DependencyGraph var1);

        default public Builder dependencyGraph(Consumer<DependencyGraph.Builder> dependencyGraph) {
            return this.dependencyGraph((DependencyGraph)((DependencyGraph.Builder)DependencyGraph.builder().applyMutation(dependencyGraph)).build());
        }

        public Builder type(String var1);
    }
}

