/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceOperationsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceOperation;

public class ListServiceOperationsIterable
implements SdkIterable<ListServiceOperationsResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceOperationsIterable(ApplicationSignalsClient client, ListServiceOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceOperationsResponseFetcher();
    }

    public Iterator<ListServiceOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceOperation> serviceOperations() {
        Function<ListServiceOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceOperations() != null) {
                return response.serviceOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceOperationsResponseFetcher
    implements SyncPageFetcher<ListServiceOperationsResponse> {
        private ListServiceOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceOperationsResponse nextPage(ListServiceOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceOperationsIterable.this.client.listServiceOperations(ListServiceOperationsIterable.this.firstRequest);
            }
            return ListServiceOperationsIterable.this.client.listServiceOperations((ListServiceOperationsRequest)((Object)ListServiceOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

