/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary;

public class ListServiceLevelObjectivesIterable
implements SdkIterable<ListServiceLevelObjectivesResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceLevelObjectivesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceLevelObjectivesIterable(ApplicationSignalsClient client, ListServiceLevelObjectivesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceLevelObjectivesResponseFetcher();
    }

    public Iterator<ListServiceLevelObjectivesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceLevelObjectiveSummary> sloSummaries() {
        Function<ListServiceLevelObjectivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sloSummaries() != null) {
                return response.sloSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceLevelObjectivesResponseFetcher
    implements SyncPageFetcher<ListServiceLevelObjectivesResponse> {
        private ListServiceLevelObjectivesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceLevelObjectivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceLevelObjectivesResponse nextPage(ListServiceLevelObjectivesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceLevelObjectivesIterable.this.client.listServiceLevelObjectives(ListServiceLevelObjectivesIterable.this.firstRequest);
            }
            return ListServiceLevelObjectivesIterable.this.client.listServiceLevelObjectives((ListServiceLevelObjectivesRequest)((Object)ListServiceLevelObjectivesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

