/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributeMapsCopier;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.LogGroupReferencesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricReference;
import software.amazon.awssdk.services.applicationsignals.model.MetricReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(Service.getter(Service::keyAttributes)).setter(Service.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> ATTRIBUTE_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeMaps").getter(Service.getter(Service::attributeMaps)).setter(Service.setter(Builder::attributeMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricReferences").getter(Service.getter(Service::metricReferences)).setter(Service.setter(Builder::metricReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> LOG_GROUP_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogGroupReferences").getter(Service.getter(Service::logGroupReferences)).setter(Service.setter(Builder::logGroupReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, ATTRIBUTE_MAPS_FIELD, METRIC_REFERENCES_FIELD, LOG_GROUP_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Service.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> keyAttributes;
    private final List<Map<String, String>> attributeMaps;
    private final List<MetricReference> metricReferences;
    private final List<Map<String, String>> logGroupReferences;

    private Service(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.attributeMaps = builder.attributeMaps;
        this.metricReferences = builder.metricReferences;
        this.logGroupReferences = builder.logGroupReferences;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final boolean hasAttributeMaps() {
        return this.attributeMaps != null && !(this.attributeMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> attributeMaps() {
        return this.attributeMaps;
    }

    public final boolean hasMetricReferences() {
        return this.metricReferences != null && !(this.metricReferences instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> metricReferences() {
        return this.metricReferences;
    }

    public final boolean hasLogGroupReferences() {
        return this.logGroupReferences != null && !(this.logGroupReferences instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> logGroupReferences() {
        return this.logGroupReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeMaps() ? this.attributeMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricReferences() ? this.metricReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupReferences() ? this.logGroupReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && this.hasAttributeMaps() == other.hasAttributeMaps() && Objects.equals(this.attributeMaps(), other.attributeMaps()) && this.hasMetricReferences() == other.hasMetricReferences() && Objects.equals(this.metricReferences(), other.metricReferences()) && this.hasLogGroupReferences() == other.hasLogGroupReferences() && Objects.equals(this.logGroupReferences(), other.logGroupReferences());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("AttributeMaps", this.hasAttributeMaps() ? this.attributeMaps() : null).add("MetricReferences", this.hasMetricReferences() ? this.metricReferences() : null).add("LogGroupReferences", this.hasLogGroupReferences() ? this.logGroupReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "AttributeMaps": {
                return Optional.ofNullable(clazz.cast(this.attributeMaps()));
            }
            case "MetricReferences": {
                return Optional.ofNullable(clazz.cast(this.metricReferences()));
            }
            case "LogGroupReferences": {
                return Optional.ofNullable(clazz.cast(this.logGroupReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("AttributeMaps", ATTRIBUTE_MAPS_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        map.put("LogGroupReferences", LOG_GROUP_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<Map<String, String>> attributeMaps = DefaultSdkAutoConstructList.getInstance();
        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, String>> logGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.keyAttributes(model.keyAttributes);
            this.attributeMaps(model.attributeMaps);
            this.metricReferences(model.metricReferences);
            this.logGroupReferences(model.logGroupReferences);
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final Collection<? extends Map<String, String>> getAttributeMaps() {
            if (this.attributeMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeMaps;
        }

        public final void setAttributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
        }

        @Override
        public final Builder attributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeMaps(Map<String, String> ... attributeMaps) {
            this.attributeMaps(Arrays.asList(attributeMaps));
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference ... metricReferences) {
            this.metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder> ... metricReferences) {
            this.metricReferences(Stream.of(metricReferences).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, String>> getLogGroupReferences() {
            if (this.logGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupReferences;
        }

        public final void setLogGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
        }

        @Override
        public final Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupReferences(Map<String, String> ... logGroupReferences) {
            this.logGroupReferences(Arrays.asList(logGroupReferences));
            return this;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder keyAttributes(Map<String, String> var1);

        public Builder attributeMaps(Collection<? extends Map<String, String>> var1);

        public Builder attributeMaps(Map<String, String> ... var1);

        public Builder metricReferences(Collection<MetricReference> var1);

        public Builder metricReferences(MetricReference ... var1);

        public Builder metricReferences(Consumer<MetricReference.Builder> ... var1);

        public Builder logGroupReferences(Collection<? extends Map<String, String>> var1);

        public Builder logGroupReferences(Map<String, String> ... var1);
    }
}

