/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.services.applicationinsights.model.UpdateStatus;
import software.amazon.awssdk.services.applicationinsights.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProblemRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, UpdateProblemRequest> {
    private static final SdkField<String> PROBLEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProblemId").getter(UpdateProblemRequest.getter(UpdateProblemRequest::problemId)).setter(UpdateProblemRequest.setter(Builder::problemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemId").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(UpdateProblemRequest.getter(UpdateProblemRequest::updateStatusAsString)).setter(UpdateProblemRequest.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(UpdateProblemRequest.getter(UpdateProblemRequest::visibilityAsString)).setter(UpdateProblemRequest.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_ID_FIELD, UPDATE_STATUS_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProblemRequest.memberNameToFieldInitializer();
    private final String problemId;
    private final String updateStatus;
    private final String visibility;

    private UpdateProblemRequest(BuilderImpl builder) {
        super(builder);
        this.problemId = builder.problemId;
        this.updateStatus = builder.updateStatus;
        this.visibility = builder.visibility;
    }

    public final String problemId() {
        return this.problemId;
    }

    public final UpdateStatus updateStatus() {
        return UpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.problemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProblemRequest)) {
            return false;
        }
        UpdateProblemRequest other = (UpdateProblemRequest)((Object)obj);
        return Objects.equals(this.problemId(), other.problemId()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProblemRequest").add("ProblemId", (Object)this.problemId()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProblemId": {
                return Optional.ofNullable(clazz.cast(this.problemId()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProblemId", PROBLEM_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProblemRequest, T> g) {
        return obj -> g.apply((UpdateProblemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String problemId;
        private String updateStatus;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProblemRequest model) {
            super(model);
            this.problemId(model.problemId);
            this.updateStatus(model.updateStatus);
            this.visibility(model.visibility);
        }

        public final String getProblemId() {
            return this.problemId;
        }

        public final void setProblemId(String problemId) {
            this.problemId = problemId;
        }

        @Override
        public final Builder problemId(String problemId) {
            this.problemId = problemId;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(UpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProblemRequest build() {
            return new UpdateProblemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProblemRequest> {
        public Builder problemId(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(UpdateStatus var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

