/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.services.applicationinsights.model.RecommendationType;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComponentConfigurationRecommendationRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, DescribeComponentConfigurationRecommendationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(DescribeComponentConfigurationRecommendationRequest.getter(DescribeComponentConfigurationRecommendationRequest::resourceGroupName)).setter(DescribeComponentConfigurationRecommendationRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(DescribeComponentConfigurationRecommendationRequest.getter(DescribeComponentConfigurationRecommendationRequest::componentName)).setter(DescribeComponentConfigurationRecommendationRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(DescribeComponentConfigurationRecommendationRequest.getter(DescribeComponentConfigurationRecommendationRequest::tierAsString)).setter(DescribeComponentConfigurationRecommendationRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(DescribeComponentConfigurationRecommendationRequest.getter(DescribeComponentConfigurationRecommendationRequest::workloadName)).setter(DescribeComponentConfigurationRecommendationRequest.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationType").getter(DescribeComponentConfigurationRecommendationRequest.getter(DescribeComponentConfigurationRecommendationRequest::recommendationTypeAsString)).setter(DescribeComponentConfigurationRecommendationRequest.setter(Builder::recommendationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, COMPONENT_NAME_FIELD, TIER_FIELD, WORKLOAD_NAME_FIELD, RECOMMENDATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComponentConfigurationRecommendationRequest.memberNameToFieldInitializer();
    private final String resourceGroupName;
    private final String componentName;
    private final String tier;
    private final String workloadName;
    private final String recommendationType;

    private DescribeComponentConfigurationRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.tier = builder.tier;
        this.workloadName = builder.workloadName;
        this.recommendationType = builder.recommendationType;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final RecommendationType recommendationType() {
        return RecommendationType.fromValue(this.recommendationType);
    }

    public final String recommendationTypeAsString() {
        return this.recommendationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentConfigurationRecommendationRequest)) {
            return false;
        }
        DescribeComponentConfigurationRecommendationRequest other = (DescribeComponentConfigurationRecommendationRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.recommendationTypeAsString(), other.recommendationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComponentConfigurationRecommendationRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("ComponentName", (Object)this.componentName()).add("Tier", (Object)this.tierAsString()).add("WorkloadName", (Object)this.workloadName()).add("RecommendationType", (Object)this.recommendationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "RecommendationType": {
                return Optional.ofNullable(clazz.cast(this.recommendationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        map.put("RecommendationType", RECOMMENDATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentConfigurationRecommendationRequest, T> g) {
        return obj -> g.apply((DescribeComponentConfigurationRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String componentName;
        private String tier;
        private String workloadName;
        private String recommendationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentConfigurationRecommendationRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.componentName(model.componentName);
            this.tier(model.tier);
            this.workloadName(model.workloadName);
            this.recommendationType(model.recommendationType);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getRecommendationType() {
            return this.recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        @Override
        public final Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType(recommendationType == null ? null : recommendationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComponentConfigurationRecommendationRequest build() {
            return new DescribeComponentConfigurationRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComponentConfigurationRecommendationRequest> {
        public Builder resourceGroupName(String var1);

        public Builder componentName(String var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder workloadName(String var1);

        public Builder recommendationType(String var1);

        public Builder recommendationType(RecommendationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

