/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadConfiguration> {
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(WorkloadConfiguration.getter(WorkloadConfiguration::workloadName)).setter(WorkloadConfiguration.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(WorkloadConfiguration.getter(WorkloadConfiguration::tierAsString)).setter(WorkloadConfiguration.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(WorkloadConfiguration.getter(WorkloadConfiguration::configuration)).setter(WorkloadConfiguration.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_FIELD, TIER_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workloadName;
    private final String tier;
    private final String configuration;

    private WorkloadConfiguration(BuilderImpl builder) {
        this.workloadName = builder.workloadName;
        this.tier = builder.tier;
        this.configuration = builder.configuration;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadConfiguration)) {
            return false;
        }
        WorkloadConfiguration other = (WorkloadConfiguration)obj;
        return Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadConfiguration").add("WorkloadName", (Object)this.workloadName()).add("Tier", (Object)this.tierAsString()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadConfiguration, T> g) {
        return obj -> g.apply((WorkloadConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadName;
        private String tier;
        private String configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadConfiguration model) {
            this.workloadName(model.workloadName);
            this.tier(model.tier);
            this.configuration(model.configuration);
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public WorkloadConfiguration build() {
            return new WorkloadConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadConfiguration> {
        public Builder workloadName(String var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder configuration(String var1);
    }
}

