/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationEventResourceType {
    CLOUDWATCH_ALARM("CLOUDWATCH_ALARM"),
    CLOUDWATCH_LOG("CLOUDWATCH_LOG"),
    CLOUDFORMATION("CLOUDFORMATION"),
    SSM_ASSOCIATION("SSM_ASSOCIATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationEventResourceType> VALUE_MAP;
    private final String value;

    private ConfigurationEventResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationEventResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationEventResourceType> knownValues() {
        EnumSet<ConfigurationEventResourceType> knownValues = EnumSet.allOf(ConfigurationEventResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationEventResourceType.class, ConfigurationEventResourceType::toString);
    }
}

