/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, CreateComponentRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(CreateComponentRequest.getter(CreateComponentRequest::resourceGroupName)).setter(CreateComponentRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(CreateComponentRequest.getter(CreateComponentRequest::componentName)).setter(CreateComponentRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<List<String>> RESOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceList").getter(CreateComponentRequest.getter(CreateComponentRequest::resourceList)).setter(CreateComponentRequest.setter(Builder::resourceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, COMPONENT_NAME_FIELD, RESOURCE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComponentRequest.memberNameToFieldInitializer();
    private final String resourceGroupName;
    private final String componentName;
    private final List<String> resourceList;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.resourceList = builder.resourceList;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final boolean hasResourceList() {
        return this.resourceList != null && !(this.resourceList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceList() {
        return this.resourceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceList() ? this.resourceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.componentName(), other.componentName()) && this.hasResourceList() == other.hasResourceList() && Objects.equals(this.resourceList(), other.resourceList());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComponentRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("ComponentName", (Object)this.componentName()).add("ResourceList", this.hasResourceList() ? this.resourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "ResourceList": {
                return Optional.ofNullable(clazz.cast(this.resourceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("ResourceList", RESOURCE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String componentName;
        private List<String> resourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.componentName(model.componentName);
            this.resourceList(model.resourceList);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Collection<String> getResourceList() {
            if (this.resourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceList;
        }

        public final void setResourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
        }

        @Override
        public final Builder resourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceList(String ... resourceList) {
            this.resourceList(Arrays.asList(resourceList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentRequest> {
        public Builder resourceGroupName(String var1);

        public Builder componentName(String var1);

        public Builder resourceList(Collection<String> var1);

        public Builder resourceList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

