/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OsType {
    WINDOWS("WINDOWS"),
    LINUX("LINUX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OsType> VALUE_MAP;
    private final String value;

    private OsType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OsType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OsType> knownValues() {
        EnumSet<OsType> knownValues = EnumSet.allOf(OsType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OsType.class, OsType::toString);
    }
}

