/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteConfigurationTaskStatus;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.DeletionConfigurationItemType;
import software.amazon.awssdk.services.applicationdiscovery.model.DeletionWarning;
import software.amazon.awssdk.services.applicationdiscovery.model.DeletionWarningsListCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.FailedConfiguration;
import software.amazon.awssdk.services.applicationdiscovery.model.FailedConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteConfigurationTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDeleteConfigurationTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::taskId)).setter(BatchDeleteConfigurationTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::statusAsString)).setter(BatchDeleteConfigurationTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::startTime)).setter(BatchDeleteConfigurationTask.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::endTime)).setter(BatchDeleteConfigurationTask.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationType").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::configurationTypeAsString)).setter(BatchDeleteConfigurationTask.setter(Builder::configurationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationType").build()}).build();
    private static final SdkField<List<String>> REQUESTED_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requestedConfigurations").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::requestedConfigurations)).setter(BatchDeleteConfigurationTask.setter(Builder::requestedConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DELETED_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deletedConfigurations").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::deletedConfigurations)).setter(BatchDeleteConfigurationTask.setter(Builder::deletedConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedConfiguration>> FAILED_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedConfigurations").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::failedConfigurations)).setter(BatchDeleteConfigurationTask.setter(Builder::failedConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeletionWarning>> DELETION_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deletionWarnings").getter(BatchDeleteConfigurationTask.getter(BatchDeleteConfigurationTask::deletionWarnings)).setter(BatchDeleteConfigurationTask.setter(Builder::deletionWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionWarnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeletionWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CONFIGURATION_TYPE_FIELD, REQUESTED_CONFIGURATIONS_FIELD, DELETED_CONFIGURATIONS_FIELD, FAILED_CONFIGURATIONS_FIELD, DELETION_WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteConfigurationTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String configurationType;
    private final List<String> requestedConfigurations;
    private final List<String> deletedConfigurations;
    private final List<FailedConfiguration> failedConfigurations;
    private final List<DeletionWarning> deletionWarnings;

    private BatchDeleteConfigurationTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.configurationType = builder.configurationType;
        this.requestedConfigurations = builder.requestedConfigurations;
        this.deletedConfigurations = builder.deletedConfigurations;
        this.failedConfigurations = builder.failedConfigurations;
        this.deletionWarnings = builder.deletionWarnings;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final BatchDeleteConfigurationTaskStatus status() {
        return BatchDeleteConfigurationTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final DeletionConfigurationItemType configurationType() {
        return DeletionConfigurationItemType.fromValue(this.configurationType);
    }

    public final String configurationTypeAsString() {
        return this.configurationType;
    }

    public final boolean hasRequestedConfigurations() {
        return this.requestedConfigurations != null && !(this.requestedConfigurations instanceof SdkAutoConstructList);
    }

    public final List<String> requestedConfigurations() {
        return this.requestedConfigurations;
    }

    public final boolean hasDeletedConfigurations() {
        return this.deletedConfigurations != null && !(this.deletedConfigurations instanceof SdkAutoConstructList);
    }

    public final List<String> deletedConfigurations() {
        return this.deletedConfigurations;
    }

    public final boolean hasFailedConfigurations() {
        return this.failedConfigurations != null && !(this.failedConfigurations instanceof SdkAutoConstructList);
    }

    public final List<FailedConfiguration> failedConfigurations() {
        return this.failedConfigurations;
    }

    public final boolean hasDeletionWarnings() {
        return this.deletionWarnings != null && !(this.deletionWarnings instanceof SdkAutoConstructList);
    }

    public final List<DeletionWarning> deletionWarnings() {
        return this.deletionWarnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedConfigurations() ? this.requestedConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletedConfigurations() ? this.deletedConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedConfigurations() ? this.failedConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletionWarnings() ? this.deletionWarnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConfigurationTask)) {
            return false;
        }
        BatchDeleteConfigurationTask other = (BatchDeleteConfigurationTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && this.hasRequestedConfigurations() == other.hasRequestedConfigurations() && Objects.equals(this.requestedConfigurations(), other.requestedConfigurations()) && this.hasDeletedConfigurations() == other.hasDeletedConfigurations() && Objects.equals(this.deletedConfigurations(), other.deletedConfigurations()) && this.hasFailedConfigurations() == other.hasFailedConfigurations() && Objects.equals(this.failedConfigurations(), other.failedConfigurations()) && this.hasDeletionWarnings() == other.hasDeletionWarnings() && Objects.equals(this.deletionWarnings(), other.deletionWarnings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteConfigurationTask").add("TaskId", (Object)this.taskId()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ConfigurationType", (Object)this.configurationTypeAsString()).add("RequestedConfigurations", this.hasRequestedConfigurations() ? this.requestedConfigurations() : null).add("DeletedConfigurations", this.hasDeletedConfigurations() ? this.deletedConfigurations() : null).add("FailedConfigurations", this.hasFailedConfigurations() ? this.failedConfigurations() : null).add("DeletionWarnings", this.hasDeletionWarnings() ? this.deletionWarnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "configurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "requestedConfigurations": {
                return Optional.ofNullable(clazz.cast(this.requestedConfigurations()));
            }
            case "deletedConfigurations": {
                return Optional.ofNullable(clazz.cast(this.deletedConfigurations()));
            }
            case "failedConfigurations": {
                return Optional.ofNullable(clazz.cast(this.failedConfigurations()));
            }
            case "deletionWarnings": {
                return Optional.ofNullable(clazz.cast(this.deletionWarnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("configurationType", CONFIGURATION_TYPE_FIELD);
        map.put("requestedConfigurations", REQUESTED_CONFIGURATIONS_FIELD);
        map.put("deletedConfigurations", DELETED_CONFIGURATIONS_FIELD);
        map.put("failedConfigurations", FAILED_CONFIGURATIONS_FIELD);
        map.put("deletionWarnings", DELETION_WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteConfigurationTask, T> g) {
        return obj -> g.apply((BatchDeleteConfigurationTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String configurationType;
        private List<String> requestedConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<String> deletedConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<FailedConfiguration> failedConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<DeletionWarning> deletionWarnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConfigurationTask model) {
            this.taskId(model.taskId);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.configurationType(model.configurationType);
            this.requestedConfigurations(model.requestedConfigurations);
            this.deletedConfigurations(model.deletedConfigurations);
            this.failedConfigurations(model.failedConfigurations);
            this.deletionWarnings(model.deletionWarnings);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchDeleteConfigurationTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(DeletionConfigurationItemType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final Collection<String> getRequestedConfigurations() {
            if (this.requestedConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedConfigurations;
        }

        public final void setRequestedConfigurations(Collection<String> requestedConfigurations) {
            this.requestedConfigurations = ConfigurationIdListCopier.copy(requestedConfigurations);
        }

        @Override
        public final Builder requestedConfigurations(Collection<String> requestedConfigurations) {
            this.requestedConfigurations = ConfigurationIdListCopier.copy(requestedConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedConfigurations(String ... requestedConfigurations) {
            this.requestedConfigurations(Arrays.asList(requestedConfigurations));
            return this;
        }

        public final Collection<String> getDeletedConfigurations() {
            if (this.deletedConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletedConfigurations;
        }

        public final void setDeletedConfigurations(Collection<String> deletedConfigurations) {
            this.deletedConfigurations = ConfigurationIdListCopier.copy(deletedConfigurations);
        }

        @Override
        public final Builder deletedConfigurations(Collection<String> deletedConfigurations) {
            this.deletedConfigurations = ConfigurationIdListCopier.copy(deletedConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedConfigurations(String ... deletedConfigurations) {
            this.deletedConfigurations(Arrays.asList(deletedConfigurations));
            return this;
        }

        public final List<FailedConfiguration.Builder> getFailedConfigurations() {
            List<FailedConfiguration.Builder> result = FailedConfigurationListCopier.copyToBuilder(this.failedConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedConfigurations(Collection<FailedConfiguration.BuilderImpl> failedConfigurations) {
            this.failedConfigurations = FailedConfigurationListCopier.copyFromBuilder(failedConfigurations);
        }

        @Override
        public final Builder failedConfigurations(Collection<FailedConfiguration> failedConfigurations) {
            this.failedConfigurations = FailedConfigurationListCopier.copy(failedConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConfigurations(FailedConfiguration ... failedConfigurations) {
            this.failedConfigurations(Arrays.asList(failedConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConfigurations(Consumer<FailedConfiguration.Builder> ... failedConfigurations) {
            this.failedConfigurations(Stream.of(failedConfigurations).map(c -> (FailedConfiguration)((FailedConfiguration.Builder)FailedConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeletionWarning.Builder> getDeletionWarnings() {
            List<DeletionWarning.Builder> result = DeletionWarningsListCopier.copyToBuilder(this.deletionWarnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeletionWarnings(Collection<DeletionWarning.BuilderImpl> deletionWarnings) {
            this.deletionWarnings = DeletionWarningsListCopier.copyFromBuilder(deletionWarnings);
        }

        @Override
        public final Builder deletionWarnings(Collection<DeletionWarning> deletionWarnings) {
            this.deletionWarnings = DeletionWarningsListCopier.copy(deletionWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletionWarnings(DeletionWarning ... deletionWarnings) {
            this.deletionWarnings(Arrays.asList(deletionWarnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletionWarnings(Consumer<DeletionWarning.Builder> ... deletionWarnings) {
            this.deletionWarnings(Stream.of(deletionWarnings).map(c -> (DeletionWarning)((DeletionWarning.Builder)DeletionWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchDeleteConfigurationTask build() {
            return new BatchDeleteConfigurationTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDeleteConfigurationTask> {
        public Builder taskId(String var1);

        public Builder status(String var1);

        public Builder status(BatchDeleteConfigurationTaskStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder configurationType(String var1);

        public Builder configurationType(DeletionConfigurationItemType var1);

        public Builder requestedConfigurations(Collection<String> var1);

        public Builder requestedConfigurations(String ... var1);

        public Builder deletedConfigurations(Collection<String> var1);

        public Builder deletedConfigurations(String ... var1);

        public Builder failedConfigurations(Collection<FailedConfiguration> var1);

        public Builder failedConfigurations(FailedConfiguration ... var1);

        public Builder failedConfigurations(Consumer<FailedConfiguration.Builder> ... var1);

        public Builder deletionWarnings(Collection<DeletionWarning> var1);

        public Builder deletionWarnings(DeletionWarning ... var1);

        public Builder deletionWarnings(Consumer<DeletionWarning.Builder> ... var1);
    }
}

