/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DataSource;
import software.amazon.awssdk.services.applicationdiscovery.model.SchemaStorageConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContinuousExportResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, StartContinuousExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(StartContinuousExportResponse.getter(StartContinuousExportResponse::exportId)).setter(StartContinuousExportResponse.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(StartContinuousExportResponse.getter(StartContinuousExportResponse::s3Bucket)).setter(StartContinuousExportResponse.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StartContinuousExportResponse.getter(StartContinuousExportResponse::startTime)).setter(StartContinuousExportResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSource").getter(StartContinuousExportResponse.getter(StartContinuousExportResponse::dataSourceAsString)).setter(StartContinuousExportResponse.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<Map<String, String>> SCHEMA_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("schemaStorageConfig").getter(StartContinuousExportResponse.getter(StartContinuousExportResponse::schemaStorageConfig)).setter(StartContinuousExportResponse.setter(Builder::schemaStorageConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaStorageConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, S3_BUCKET_FIELD, START_TIME_FIELD, DATA_SOURCE_FIELD, SCHEMA_STORAGE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartContinuousExportResponse.memberNameToFieldInitializer();
    private final String exportId;
    private final String s3Bucket;
    private final Instant startTime;
    private final String dataSource;
    private final Map<String, String> schemaStorageConfig;

    private StartContinuousExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.s3Bucket = builder.s3Bucket;
        this.startTime = builder.startTime;
        this.dataSource = builder.dataSource;
        this.schemaStorageConfig = builder.schemaStorageConfig;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final DataSource dataSource() {
        return DataSource.fromValue(this.dataSource);
    }

    public final String dataSourceAsString() {
        return this.dataSource;
    }

    public final boolean hasSchemaStorageConfig() {
        return this.schemaStorageConfig != null && !(this.schemaStorageConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> schemaStorageConfig() {
        return this.schemaStorageConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaStorageConfig() ? this.schemaStorageConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContinuousExportResponse)) {
            return false;
        }
        StartContinuousExportResponse other = (StartContinuousExportResponse)((Object)obj);
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && this.hasSchemaStorageConfig() == other.hasSchemaStorageConfig() && Objects.equals(this.schemaStorageConfig(), other.schemaStorageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StartContinuousExportResponse").add("ExportId", (Object)this.exportId()).add("S3Bucket", (Object)this.s3Bucket()).add("StartTime", (Object)this.startTime()).add("DataSource", (Object)this.dataSourceAsString()).add("SchemaStorageConfig", this.hasSchemaStorageConfig() ? this.schemaStorageConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "schemaStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.schemaStorageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exportId", EXPORT_ID_FIELD);
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("schemaStorageConfig", SCHEMA_STORAGE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContinuousExportResponse, T> g) {
        return obj -> g.apply((StartContinuousExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private String exportId;
        private String s3Bucket;
        private Instant startTime;
        private String dataSource;
        private Map<String, String> schemaStorageConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartContinuousExportResponse model) {
            super(model);
            this.exportId(model.exportId);
            this.s3Bucket(model.s3Bucket);
            this.startTime(model.startTime);
            this.dataSource(model.dataSource);
            this.schemaStorageConfig(model.schemaStorageConfig);
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final Map<String, String> getSchemaStorageConfig() {
            if (this.schemaStorageConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.schemaStorageConfig;
        }

        public final void setSchemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
        }

        @Override
        public final Builder schemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
            return this;
        }

        @Override
        public StartContinuousExportResponse build() {
            return new StartContinuousExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContinuousExportResponse> {
        public Builder exportId(String var1);

        public Builder s3Bucket(String var1);

        public Builder startTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder dataSource(DataSource var1);

        public Builder schemaStorageConfig(Map<String, String> var1);
    }
}

