/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationTag;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsResponse;

public class DescribeTagsIterable
implements SdkIterable<DescribeTagsResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTagsIterable(ApplicationDiscoveryClient client, DescribeTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public Iterator<DescribeTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationTag> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTagsResponseFetcher
    implements SyncPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTagsResponse nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsIterable.this.client.describeTags(DescribeTagsIterable.this.firstRequest);
            }
            return DescribeTagsIterable.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

