/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileClassification {
    MODELIZEIT_EXPORT("MODELIZEIT_EXPORT"),
    RVTOOLS_EXPORT("RVTOOLS_EXPORT"),
    VMWARE_NSX_EXPORT("VMWARE_NSX_EXPORT"),
    IMPORT_TEMPLATE("IMPORT_TEMPLATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileClassification> VALUE_MAP;
    private final String value;

    private FileClassification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileClassification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileClassification> knownValues() {
        EnumSet<FileClassification> knownValues = EnumSet.allOf(FileClassification.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileClassification.class, FileClassification::toString);
    }
}

