/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactHandlingScope {
    CROSS_CONTACTS("CROSS_CONTACTS"),
    PER_CONTACT("PER_CONTACT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactHandlingScope> VALUE_MAP;
    private final String value;

    private ContactHandlingScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactHandlingScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactHandlingScope> knownValues() {
        EnumSet<ContactHandlingScope> knownValues = EnumSet.allOf(ContactHandlingScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactHandlingScope.class, ContactHandlingScope::toString);
    }
}

