/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ExecutionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataIntegrationAssociationRequest
extends AppIntegrationsRequest
implements ToCopyableBuilder<Builder, UpdateDataIntegrationAssociationRequest> {
    private static final SdkField<String> DATA_INTEGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataIntegrationIdentifier").getter(UpdateDataIntegrationAssociationRequest.getter(UpdateDataIntegrationAssociationRequest::dataIntegrationIdentifier)).setter(UpdateDataIntegrationAssociationRequest.setter(Builder::dataIntegrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> DATA_INTEGRATION_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataIntegrationAssociationIdentifier").getter(UpdateDataIntegrationAssociationRequest.getter(UpdateDataIntegrationAssociationRequest::dataIntegrationAssociationIdentifier)).setter(UpdateDataIntegrationAssociationRequest.setter(Builder::dataIntegrationAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataIntegrationAssociationIdentifier").build()}).build();
    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionConfiguration").getter(UpdateDataIntegrationAssociationRequest.getter(UpdateDataIntegrationAssociationRequest::executionConfiguration)).setter(UpdateDataIntegrationAssociationRequest.setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_INTEGRATION_IDENTIFIER_FIELD, DATA_INTEGRATION_ASSOCIATION_IDENTIFIER_FIELD, EXECUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataIntegrationAssociationRequest.memberNameToFieldInitializer();
    private final String dataIntegrationIdentifier;
    private final String dataIntegrationAssociationIdentifier;
    private final ExecutionConfiguration executionConfiguration;

    private UpdateDataIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationIdentifier = builder.dataIntegrationIdentifier;
        this.dataIntegrationAssociationIdentifier = builder.dataIntegrationAssociationIdentifier;
        this.executionConfiguration = builder.executionConfiguration;
    }

    public final String dataIntegrationIdentifier() {
        return this.dataIntegrationIdentifier;
    }

    public final String dataIntegrationAssociationIdentifier() {
        return this.dataIntegrationAssociationIdentifier;
    }

    public final ExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataIntegrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataIntegrationAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataIntegrationAssociationRequest)) {
            return false;
        }
        UpdateDataIntegrationAssociationRequest other = (UpdateDataIntegrationAssociationRequest)((Object)obj);
        return Objects.equals(this.dataIntegrationIdentifier(), other.dataIntegrationIdentifier()) && Objects.equals(this.dataIntegrationAssociationIdentifier(), other.dataIntegrationAssociationIdentifier()) && Objects.equals(this.executionConfiguration(), other.executionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataIntegrationAssociationRequest").add("DataIntegrationIdentifier", (Object)this.dataIntegrationIdentifier()).add("DataIntegrationAssociationIdentifier", (Object)this.dataIntegrationAssociationIdentifier()).add("ExecutionConfiguration", (Object)this.executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataIntegrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataIntegrationIdentifier()));
            }
            case "DataIntegrationAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataIntegrationAssociationIdentifier()));
            }
            case "ExecutionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", DATA_INTEGRATION_IDENTIFIER_FIELD);
        map.put("DataIntegrationAssociationIdentifier", DATA_INTEGRATION_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("ExecutionConfiguration", EXECUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDataIntegrationAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsRequest.BuilderImpl
    implements Builder {
        private String dataIntegrationIdentifier;
        private String dataIntegrationAssociationIdentifier;
        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataIntegrationAssociationRequest model) {
            super(model);
            this.dataIntegrationIdentifier(model.dataIntegrationIdentifier);
            this.dataIntegrationAssociationIdentifier(model.dataIntegrationAssociationIdentifier);
            this.executionConfiguration(model.executionConfiguration);
        }

        public final String getDataIntegrationIdentifier() {
            return this.dataIntegrationIdentifier;
        }

        public final void setDataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
        }

        @Override
        public final Builder dataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
            return this;
        }

        public final String getDataIntegrationAssociationIdentifier() {
            return this.dataIntegrationAssociationIdentifier;
        }

        public final void setDataIntegrationAssociationIdentifier(String dataIntegrationAssociationIdentifier) {
            this.dataIntegrationAssociationIdentifier = dataIntegrationAssociationIdentifier;
        }

        @Override
        public final Builder dataIntegrationAssociationIdentifier(String dataIntegrationAssociationIdentifier) {
            this.dataIntegrationAssociationIdentifier = dataIntegrationAssociationIdentifier;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return this.executionConfiguration != null ? this.executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataIntegrationAssociationRequest build() {
            return new UpdateDataIntegrationAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataIntegrationAssociationRequest> {
        public Builder dataIntegrationIdentifier(String var1);

        public Builder dataIntegrationAssociationIdentifier(String var1);

        public Builder executionConfiguration(ExecutionConfiguration var1);

        default public Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return this.executionConfiguration((ExecutionConfiguration)((ExecutionConfiguration.Builder)ExecutionConfiguration.builder().applyMutation(executionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

