/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.ApplicationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse;

public class ListApplicationsIterable
implements SdkIterable<ListApplicationsResponse> {
    private final AppIntegrationsClient client;
    private final ListApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationsIterable(AppIntegrationsClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public Iterator<ListApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationSummary> applications() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationsResponseFetcher
    implements SyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsIterable.this.client.listApplications(ListApplicationsIterable.this.firstRequest);
            }
            return ListApplicationsIterable.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

