/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse;

public class ListDataIntegrationAssociationsPublisher
implements SdkPublisher<ListDataIntegrationAssociationsResponse> {
    private final AppIntegrationsAsyncClient client;
    private final ListDataIntegrationAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIntegrationAssociationsPublisher(AppIntegrationsAsyncClient client, ListDataIntegrationAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIntegrationAssociationsPublisher(AppIntegrationsAsyncClient client, ListDataIntegrationAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIntegrationAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIntegrationAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataIntegrationAssociationSummary> dataIntegrationAssociations() {
        Function<ListDataIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataIntegrationAssociations() != null) {
                return response.dataIntegrationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataIntegrationAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataIntegrationAssociationsResponseFetcher
    implements AsyncPageFetcher<ListDataIntegrationAssociationsResponse> {
        private ListDataIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIntegrationAssociationsResponse> nextPage(ListDataIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationAssociationsPublisher.this.client.listDataIntegrationAssociations(ListDataIntegrationAssociationsPublisher.this.firstRequest);
            }
            return ListDataIntegrationAssociationsPublisher.this.client.listDataIntegrationAssociations((ListDataIntegrationAssociationsRequest)((Object)ListDataIntegrationAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

