/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedDataTransferType {
    RECORD("RECORD"),
    FILE("FILE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedDataTransferType> VALUE_MAP;
    private final String value;

    private SupportedDataTransferType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedDataTransferType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedDataTransferType> knownValues() {
        EnumSet<SupportedDataTransferType> knownValues = EnumSet.allOf(SupportedDataTransferType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedDataTransferType.class, SupportedDataTransferType::toString);
    }
}

