/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AuthCodeUrlListCopier;
import software.amazon.awssdk.services.appflow.model.OAuth2CustomParameter;
import software.amazon.awssdk.services.appflow.model.OAuth2CustomPropertiesListCopier;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantType;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantTypeSupportedListCopier;
import software.amazon.awssdk.services.appflow.model.OAuthScopeListCopier;
import software.amazon.awssdk.services.appflow.model.TokenUrlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2Defaults
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2Defaults> {
    private static final SdkField<List<String>> OAUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oauthScopes").getter(OAuth2Defaults.getter(OAuth2Defaults::oauthScopes)).setter(OAuth2Defaults.setter(Builder::oauthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TOKEN_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tokenUrls").getter(OAuth2Defaults.getter(OAuth2Defaults::tokenUrls)).setter(OAuth2Defaults.setter(Builder::tokenUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTH_CODE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authCodeUrls").getter(OAuth2Defaults.getter(OAuth2Defaults::authCodeUrls)).setter(OAuth2Defaults.setter(Builder::authCodeUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCodeUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OAUTH2_GRANT_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oauth2GrantTypesSupported").getter(OAuth2Defaults.getter(OAuth2Defaults::oauth2GrantTypesSupportedAsStrings)).setter(OAuth2Defaults.setter(Builder::oauth2GrantTypesSupportedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2GrantTypesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OAuth2CustomParameter>> OAUTH2_CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oauth2CustomProperties").getter(OAuth2Defaults.getter(OAuth2Defaults::oauth2CustomProperties)).setter(OAuth2Defaults.setter(Builder::oauth2CustomProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2CustomProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OAuth2CustomParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH_SCOPES_FIELD, TOKEN_URLS_FIELD, AUTH_CODE_URLS_FIELD, OAUTH2_GRANT_TYPES_SUPPORTED_FIELD, OAUTH2_CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2Defaults.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> oauthScopes;
    private final List<String> tokenUrls;
    private final List<String> authCodeUrls;
    private final List<String> oauth2GrantTypesSupported;
    private final List<OAuth2CustomParameter> oauth2CustomProperties;

    private OAuth2Defaults(BuilderImpl builder) {
        this.oauthScopes = builder.oauthScopes;
        this.tokenUrls = builder.tokenUrls;
        this.authCodeUrls = builder.authCodeUrls;
        this.oauth2GrantTypesSupported = builder.oauth2GrantTypesSupported;
        this.oauth2CustomProperties = builder.oauth2CustomProperties;
    }

    public final boolean hasOauthScopes() {
        return this.oauthScopes != null && !(this.oauthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> oauthScopes() {
        return this.oauthScopes;
    }

    public final boolean hasTokenUrls() {
        return this.tokenUrls != null && !(this.tokenUrls instanceof SdkAutoConstructList);
    }

    public final List<String> tokenUrls() {
        return this.tokenUrls;
    }

    public final boolean hasAuthCodeUrls() {
        return this.authCodeUrls != null && !(this.authCodeUrls instanceof SdkAutoConstructList);
    }

    public final List<String> authCodeUrls() {
        return this.authCodeUrls;
    }

    public final List<OAuth2GrantType> oauth2GrantTypesSupported() {
        return OAuth2GrantTypeSupportedListCopier.copyStringToEnum(this.oauth2GrantTypesSupported);
    }

    public final boolean hasOauth2GrantTypesSupported() {
        return this.oauth2GrantTypesSupported != null && !(this.oauth2GrantTypesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> oauth2GrantTypesSupportedAsStrings() {
        return this.oauth2GrantTypesSupported;
    }

    public final boolean hasOauth2CustomProperties() {
        return this.oauth2CustomProperties != null && !(this.oauth2CustomProperties instanceof SdkAutoConstructList);
    }

    public final List<OAuth2CustomParameter> oauth2CustomProperties() {
        return this.oauth2CustomProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOauthScopes() ? this.oauthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenUrls() ? this.tokenUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthCodeUrls() ? this.authCodeUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOauth2GrantTypesSupported() ? this.oauth2GrantTypesSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOauth2CustomProperties() ? this.oauth2CustomProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Defaults)) {
            return false;
        }
        OAuth2Defaults other = (OAuth2Defaults)obj;
        return this.hasOauthScopes() == other.hasOauthScopes() && Objects.equals(this.oauthScopes(), other.oauthScopes()) && this.hasTokenUrls() == other.hasTokenUrls() && Objects.equals(this.tokenUrls(), other.tokenUrls()) && this.hasAuthCodeUrls() == other.hasAuthCodeUrls() && Objects.equals(this.authCodeUrls(), other.authCodeUrls()) && this.hasOauth2GrantTypesSupported() == other.hasOauth2GrantTypesSupported() && Objects.equals(this.oauth2GrantTypesSupportedAsStrings(), other.oauth2GrantTypesSupportedAsStrings()) && this.hasOauth2CustomProperties() == other.hasOauth2CustomProperties() && Objects.equals(this.oauth2CustomProperties(), other.oauth2CustomProperties());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2Defaults").add("OauthScopes", this.hasOauthScopes() ? this.oauthScopes() : null).add("TokenUrls", this.hasTokenUrls() ? this.tokenUrls() : null).add("AuthCodeUrls", this.hasAuthCodeUrls() ? this.authCodeUrls() : null).add("Oauth2GrantTypesSupported", this.hasOauth2GrantTypesSupported() ? this.oauth2GrantTypesSupportedAsStrings() : null).add("Oauth2CustomProperties", this.hasOauth2CustomProperties() ? this.oauth2CustomProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oauthScopes": {
                return Optional.ofNullable(clazz.cast(this.oauthScopes()));
            }
            case "tokenUrls": {
                return Optional.ofNullable(clazz.cast(this.tokenUrls()));
            }
            case "authCodeUrls": {
                return Optional.ofNullable(clazz.cast(this.authCodeUrls()));
            }
            case "oauth2GrantTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.oauth2GrantTypesSupportedAsStrings()));
            }
            case "oauth2CustomProperties": {
                return Optional.ofNullable(clazz.cast(this.oauth2CustomProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthScopes", OAUTH_SCOPES_FIELD);
        map.put("tokenUrls", TOKEN_URLS_FIELD);
        map.put("authCodeUrls", AUTH_CODE_URLS_FIELD);
        map.put("oauth2GrantTypesSupported", OAUTH2_GRANT_TYPES_SUPPORTED_FIELD);
        map.put("oauth2CustomProperties", OAUTH2_CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Defaults, T> g) {
        return obj -> g.apply((OAuth2Defaults)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> oauthScopes = DefaultSdkAutoConstructList.getInstance();
        private List<String> tokenUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> authCodeUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> oauth2GrantTypesSupported = DefaultSdkAutoConstructList.getInstance();
        private List<OAuth2CustomParameter> oauth2CustomProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Defaults model) {
            this.oauthScopes(model.oauthScopes);
            this.tokenUrls(model.tokenUrls);
            this.authCodeUrls(model.authCodeUrls);
            this.oauth2GrantTypesSupportedWithStrings(model.oauth2GrantTypesSupported);
            this.oauth2CustomProperties(model.oauth2CustomProperties);
        }

        public final Collection<String> getOauthScopes() {
            if (this.oauthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oauthScopes;
        }

        public final void setOauthScopes(Collection<String> oauthScopes) {
            this.oauthScopes = OAuthScopeListCopier.copy(oauthScopes);
        }

        @Override
        public final Builder oauthScopes(Collection<String> oauthScopes) {
            this.oauthScopes = OAuthScopeListCopier.copy(oauthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauthScopes(String ... oauthScopes) {
            this.oauthScopes(Arrays.asList(oauthScopes));
            return this;
        }

        public final Collection<String> getTokenUrls() {
            if (this.tokenUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenUrls;
        }

        public final void setTokenUrls(Collection<String> tokenUrls) {
            this.tokenUrls = TokenUrlListCopier.copy(tokenUrls);
        }

        @Override
        public final Builder tokenUrls(Collection<String> tokenUrls) {
            this.tokenUrls = TokenUrlListCopier.copy(tokenUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenUrls(String ... tokenUrls) {
            this.tokenUrls(Arrays.asList(tokenUrls));
            return this;
        }

        public final Collection<String> getAuthCodeUrls() {
            if (this.authCodeUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authCodeUrls;
        }

        public final void setAuthCodeUrls(Collection<String> authCodeUrls) {
            this.authCodeUrls = AuthCodeUrlListCopier.copy(authCodeUrls);
        }

        @Override
        public final Builder authCodeUrls(Collection<String> authCodeUrls) {
            this.authCodeUrls = AuthCodeUrlListCopier.copy(authCodeUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authCodeUrls(String ... authCodeUrls) {
            this.authCodeUrls(Arrays.asList(authCodeUrls));
            return this;
        }

        public final Collection<String> getOauth2GrantTypesSupported() {
            if (this.oauth2GrantTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oauth2GrantTypesSupported;
        }

        public final void setOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
        }

        @Override
        public final Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupportedWithStrings(String ... oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupportedWithStrings(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        @Override
        public final Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copyEnumToString(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupported(OAuth2GrantType ... oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        public final List<OAuth2CustomParameter.Builder> getOauth2CustomProperties() {
            List<OAuth2CustomParameter.Builder> result = OAuth2CustomPropertiesListCopier.copyToBuilder(this.oauth2CustomProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOauth2CustomProperties(Collection<OAuth2CustomParameter.BuilderImpl> oauth2CustomProperties) {
            this.oauth2CustomProperties = OAuth2CustomPropertiesListCopier.copyFromBuilder(oauth2CustomProperties);
        }

        @Override
        public final Builder oauth2CustomProperties(Collection<OAuth2CustomParameter> oauth2CustomProperties) {
            this.oauth2CustomProperties = OAuth2CustomPropertiesListCopier.copy(oauth2CustomProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2CustomProperties(OAuth2CustomParameter ... oauth2CustomProperties) {
            this.oauth2CustomProperties(Arrays.asList(oauth2CustomProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2CustomProperties(Consumer<OAuth2CustomParameter.Builder> ... oauth2CustomProperties) {
            this.oauth2CustomProperties(Stream.of(oauth2CustomProperties).map(c -> (OAuth2CustomParameter)((OAuth2CustomParameter.Builder)OAuth2CustomParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OAuth2Defaults build() {
            return new OAuth2Defaults(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2Defaults> {
        public Builder oauthScopes(Collection<String> var1);

        public Builder oauthScopes(String ... var1);

        public Builder tokenUrls(Collection<String> var1);

        public Builder tokenUrls(String ... var1);

        public Builder authCodeUrls(Collection<String> var1);

        public Builder authCodeUrls(String ... var1);

        public Builder oauth2GrantTypesSupportedWithStrings(Collection<String> var1);

        public Builder oauth2GrantTypesSupportedWithStrings(String ... var1);

        public Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> var1);

        public Builder oauth2GrantTypesSupported(OAuth2GrantType ... var1);

        public Builder oauth2CustomProperties(Collection<OAuth2CustomParameter> var1);

        public Builder oauth2CustomProperties(OAuth2CustomParameter ... var1);

        public Builder oauth2CustomProperties(Consumer<OAuth2CustomParameter.Builder> ... var1);
    }
}

