/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ErrorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionResult> {
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(ExecutionResult.getter(ExecutionResult::errorInfo)).setter(ExecutionResult.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Long> BYTES_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bytesProcessed").getter(ExecutionResult.getter(ExecutionResult::bytesProcessed)).setter(ExecutionResult.setter(Builder::bytesProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesProcessed").build()}).build();
    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bytesWritten").getter(ExecutionResult.getter(ExecutionResult::bytesWritten)).setter(ExecutionResult.setter(Builder::bytesWritten)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesWritten").build()}).build();
    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("recordsProcessed").getter(ExecutionResult.getter(ExecutionResult::recordsProcessed)).setter(ExecutionResult.setter(Builder::recordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsProcessed").build()}).build();
    private static final SdkField<Long> NUM_PARALLEL_PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numParallelProcesses").getter(ExecutionResult.getter(ExecutionResult::numParallelProcesses)).setter(ExecutionResult.setter(Builder::numParallelProcesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numParallelProcesses").build()}).build();
    private static final SdkField<Long> MAX_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxPageSize").getter(ExecutionResult.getter(ExecutionResult::maxPageSize)).setter(ExecutionResult.setter(Builder::maxPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_INFO_FIELD, BYTES_PROCESSED_FIELD, BYTES_WRITTEN_FIELD, RECORDS_PROCESSED_FIELD, NUM_PARALLEL_PROCESSES_FIELD, MAX_PAGE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ErrorInfo errorInfo;
    private final Long bytesProcessed;
    private final Long bytesWritten;
    private final Long recordsProcessed;
    private final Long numParallelProcesses;
    private final Long maxPageSize;

    private ExecutionResult(BuilderImpl builder) {
        this.errorInfo = builder.errorInfo;
        this.bytesProcessed = builder.bytesProcessed;
        this.bytesWritten = builder.bytesWritten;
        this.recordsProcessed = builder.recordsProcessed;
        this.numParallelProcesses = builder.numParallelProcesses;
        this.maxPageSize = builder.maxPageSize;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final Long bytesProcessed() {
        return this.bytesProcessed;
    }

    public final Long bytesWritten() {
        return this.bytesWritten;
    }

    public final Long recordsProcessed() {
        return this.recordsProcessed;
    }

    public final Long numParallelProcesses() {
        return this.numParallelProcesses;
    }

    public final Long maxPageSize() {
        return this.maxPageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numParallelProcesses());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionResult)) {
            return false;
        }
        ExecutionResult other = (ExecutionResult)obj;
        return Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.bytesProcessed(), other.bytesProcessed()) && Objects.equals(this.bytesWritten(), other.bytesWritten()) && Objects.equals(this.recordsProcessed(), other.recordsProcessed()) && Objects.equals(this.numParallelProcesses(), other.numParallelProcesses()) && Objects.equals(this.maxPageSize(), other.maxPageSize());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionResult").add("ErrorInfo", (Object)this.errorInfo()).add("BytesProcessed", (Object)this.bytesProcessed()).add("BytesWritten", (Object)this.bytesWritten()).add("RecordsProcessed", (Object)this.recordsProcessed()).add("NumParallelProcesses", (Object)this.numParallelProcesses()).add("MaxPageSize", (Object)this.maxPageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "bytesProcessed": {
                return Optional.ofNullable(clazz.cast(this.bytesProcessed()));
            }
            case "bytesWritten": {
                return Optional.ofNullable(clazz.cast(this.bytesWritten()));
            }
            case "recordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsProcessed()));
            }
            case "numParallelProcesses": {
                return Optional.ofNullable(clazz.cast(this.numParallelProcesses()));
            }
            case "maxPageSize": {
                return Optional.ofNullable(clazz.cast(this.maxPageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("bytesProcessed", BYTES_PROCESSED_FIELD);
        map.put("bytesWritten", BYTES_WRITTEN_FIELD);
        map.put("recordsProcessed", RECORDS_PROCESSED_FIELD);
        map.put("numParallelProcesses", NUM_PARALLEL_PROCESSES_FIELD);
        map.put("maxPageSize", MAX_PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionResult, T> g) {
        return obj -> g.apply((ExecutionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ErrorInfo errorInfo;
        private Long bytesProcessed;
        private Long bytesWritten;
        private Long recordsProcessed;
        private Long numParallelProcesses;
        private Long maxPageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionResult model) {
            this.errorInfo(model.errorInfo);
            this.bytesProcessed(model.bytesProcessed);
            this.bytesWritten(model.bytesWritten);
            this.recordsProcessed(model.recordsProcessed);
            this.numParallelProcesses(model.numParallelProcesses);
            this.maxPageSize(model.maxPageSize);
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getBytesProcessed() {
            return this.bytesProcessed;
        }

        public final void setBytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
        }

        @Override
        public final Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            return this;
        }

        public final Long getBytesWritten() {
            return this.bytesWritten;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final Long getRecordsProcessed() {
            return this.recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Long getNumParallelProcesses() {
            return this.numParallelProcesses;
        }

        public final void setNumParallelProcesses(Long numParallelProcesses) {
            this.numParallelProcesses = numParallelProcesses;
        }

        @Override
        public final Builder numParallelProcesses(Long numParallelProcesses) {
            this.numParallelProcesses = numParallelProcesses;
            return this;
        }

        public final Long getMaxPageSize() {
            return this.maxPageSize;
        }

        public final void setMaxPageSize(Long maxPageSize) {
            this.maxPageSize = maxPageSize;
        }

        @Override
        public final Builder maxPageSize(Long maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public ExecutionResult build() {
            return new ExecutionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionResult> {
        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder bytesProcessed(Long var1);

        public Builder bytesWritten(Long var1);

        public Builder recordsProcessed(Long var1);

        public Builder numParallelProcesses(Long var1);

        public Builder maxPageSize(Long var1);
    }
}

