/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.ExecutionDetails;
import software.amazon.awssdk.services.appflow.model.FlowStatus;
import software.amazon.awssdk.services.appflow.model.TagMapCopier;
import software.amazon.awssdk.services.appflow.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowDefinition> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowArn").getter(FlowDefinition.getter(FlowDefinition::flowArn)).setter(FlowDefinition.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(FlowDefinition.getter(FlowDefinition::description)).setter(FlowDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(FlowDefinition.getter(FlowDefinition::flowName)).setter(FlowDefinition.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowStatus").getter(FlowDefinition.getter(FlowDefinition::flowStatusAsString)).setter(FlowDefinition.setter(Builder::flowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()}).build();
    private static final SdkField<String> SOURCE_CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceConnectorType").getter(FlowDefinition.getter(FlowDefinition::sourceConnectorTypeAsString)).setter(FlowDefinition.setter(Builder::sourceConnectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorType").build()}).build();
    private static final SdkField<String> SOURCE_CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceConnectorLabel").getter(FlowDefinition.getter(FlowDefinition::sourceConnectorLabel)).setter(FlowDefinition.setter(Builder::sourceConnectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectorLabel").build()}).build();
    private static final SdkField<String> DESTINATION_CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationConnectorType").getter(FlowDefinition.getter(FlowDefinition::destinationConnectorTypeAsString)).setter(FlowDefinition.setter(Builder::destinationConnectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorType").build()}).build();
    private static final SdkField<String> DESTINATION_CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationConnectorLabel").getter(FlowDefinition.getter(FlowDefinition::destinationConnectorLabel)).setter(FlowDefinition.setter(Builder::destinationConnectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorLabel").build()}).build();
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerType").getter(FlowDefinition.getter(FlowDefinition::triggerTypeAsString)).setter(FlowDefinition.setter(Builder::triggerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FlowDefinition.getter(FlowDefinition::createdAt)).setter(FlowDefinition.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(FlowDefinition.getter(FlowDefinition::lastUpdatedAt)).setter(FlowDefinition.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(FlowDefinition.getter(FlowDefinition::createdBy)).setter(FlowDefinition.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(FlowDefinition.getter(FlowDefinition::lastUpdatedBy)).setter(FlowDefinition.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(FlowDefinition.getter(FlowDefinition::tags)).setter(FlowDefinition.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ExecutionDetails> LAST_RUN_EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRunExecutionDetails").getter(FlowDefinition.getter(FlowDefinition::lastRunExecutionDetails)).setter(FlowDefinition.setter(Builder::lastRunExecutionDetails)).constructor(ExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunExecutionDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, DESCRIPTION_FIELD, FLOW_NAME_FIELD, FLOW_STATUS_FIELD, SOURCE_CONNECTOR_TYPE_FIELD, SOURCE_CONNECTOR_LABEL_FIELD, DESTINATION_CONNECTOR_TYPE_FIELD, DESTINATION_CONNECTOR_LABEL_FIELD, TRIGGER_TYPE_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD, LAST_RUN_EXECUTION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final String description;
    private final String flowName;
    private final String flowStatus;
    private final String sourceConnectorType;
    private final String sourceConnectorLabel;
    private final String destinationConnectorType;
    private final String destinationConnectorLabel;
    private final String triggerType;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String createdBy;
    private final String lastUpdatedBy;
    private final Map<String, String> tags;
    private final ExecutionDetails lastRunExecutionDetails;

    private FlowDefinition(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.flowStatus = builder.flowStatus;
        this.sourceConnectorType = builder.sourceConnectorType;
        this.sourceConnectorLabel = builder.sourceConnectorLabel;
        this.destinationConnectorType = builder.destinationConnectorType;
        this.destinationConnectorLabel = builder.destinationConnectorLabel;
        this.triggerType = builder.triggerType;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
        this.lastRunExecutionDetails = builder.lastRunExecutionDetails;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String description() {
        return this.description;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(this.flowStatus);
    }

    public final String flowStatusAsString() {
        return this.flowStatus;
    }

    public final ConnectorType sourceConnectorType() {
        return ConnectorType.fromValue(this.sourceConnectorType);
    }

    public final String sourceConnectorTypeAsString() {
        return this.sourceConnectorType;
    }

    public final String sourceConnectorLabel() {
        return this.sourceConnectorLabel;
    }

    public final ConnectorType destinationConnectorType() {
        return ConnectorType.fromValue(this.destinationConnectorType);
    }

    public final String destinationConnectorTypeAsString() {
        return this.destinationConnectorType;
    }

    public final String destinationConnectorLabel() {
        return this.destinationConnectorLabel;
    }

    public final TriggerType triggerType() {
        return TriggerType.fromValue(this.triggerType);
    }

    public final String triggerTypeAsString() {
        return this.triggerType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ExecutionDetails lastRunExecutionDetails() {
        return this.lastRunExecutionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConnectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunExecutionDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.flowStatusAsString(), other.flowStatusAsString()) && Objects.equals(this.sourceConnectorTypeAsString(), other.sourceConnectorTypeAsString()) && Objects.equals(this.sourceConnectorLabel(), other.sourceConnectorLabel()) && Objects.equals(this.destinationConnectorTypeAsString(), other.destinationConnectorTypeAsString()) && Objects.equals(this.destinationConnectorLabel(), other.destinationConnectorLabel()) && Objects.equals(this.triggerTypeAsString(), other.triggerTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastRunExecutionDetails(), other.lastRunExecutionDetails());
    }

    public final String toString() {
        return ToString.builder((String)"FlowDefinition").add("FlowArn", (Object)this.flowArn()).add("Description", (Object)this.description()).add("FlowName", (Object)this.flowName()).add("FlowStatus", (Object)this.flowStatusAsString()).add("SourceConnectorType", (Object)this.sourceConnectorTypeAsString()).add("SourceConnectorLabel", (Object)this.sourceConnectorLabel()).add("DestinationConnectorType", (Object)this.destinationConnectorTypeAsString()).add("DestinationConnectorLabel", (Object)this.destinationConnectorLabel()).add("TriggerType", (Object)this.triggerTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedBy", (Object)this.createdBy()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Tags", this.hasTags() ? this.tags() : null).add("LastRunExecutionDetails", (Object)this.lastRunExecutionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "flowStatus": {
                return Optional.ofNullable(clazz.cast(this.flowStatusAsString()));
            }
            case "sourceConnectorType": {
                return Optional.ofNullable(clazz.cast(this.sourceConnectorTypeAsString()));
            }
            case "sourceConnectorLabel": {
                return Optional.ofNullable(clazz.cast(this.sourceConnectorLabel()));
            }
            case "destinationConnectorType": {
                return Optional.ofNullable(clazz.cast(this.destinationConnectorTypeAsString()));
            }
            case "destinationConnectorLabel": {
                return Optional.ofNullable(clazz.cast(this.destinationConnectorLabel()));
            }
            case "triggerType": {
                return Optional.ofNullable(clazz.cast(this.triggerTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "lastRunExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.lastRunExecutionDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("flowStatus", FLOW_STATUS_FIELD);
        map.put("sourceConnectorType", SOURCE_CONNECTOR_TYPE_FIELD);
        map.put("sourceConnectorLabel", SOURCE_CONNECTOR_LABEL_FIELD);
        map.put("destinationConnectorType", DESTINATION_CONNECTOR_TYPE_FIELD);
        map.put("destinationConnectorLabel", DESTINATION_CONNECTOR_LABEL_FIELD);
        map.put("triggerType", TRIGGER_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("lastRunExecutionDetails", LAST_RUN_EXECUTION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private String description;
        private String flowName;
        private String flowStatus;
        private String sourceConnectorType;
        private String sourceConnectorLabel;
        private String destinationConnectorType;
        private String destinationConnectorLabel;
        private String triggerType;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String createdBy;
        private String lastUpdatedBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ExecutionDetails lastRunExecutionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            this.flowArn(model.flowArn);
            this.description(model.description);
            this.flowName(model.flowName);
            this.flowStatus(model.flowStatus);
            this.sourceConnectorType(model.sourceConnectorType);
            this.sourceConnectorLabel(model.sourceConnectorLabel);
            this.destinationConnectorType(model.destinationConnectorType);
            this.destinationConnectorLabel(model.destinationConnectorLabel);
            this.triggerType(model.triggerType);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdBy(model.createdBy);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.tags(model.tags);
            this.lastRunExecutionDetails(model.lastRunExecutionDetails);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getFlowStatus() {
            return this.flowStatus;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final String getSourceConnectorType() {
            return this.sourceConnectorType;
        }

        public final void setSourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
        }

        @Override
        public final Builder sourceConnectorType(String sourceConnectorType) {
            this.sourceConnectorType = sourceConnectorType;
            return this;
        }

        @Override
        public final Builder sourceConnectorType(ConnectorType sourceConnectorType) {
            this.sourceConnectorType(sourceConnectorType == null ? null : sourceConnectorType.toString());
            return this;
        }

        public final String getSourceConnectorLabel() {
            return this.sourceConnectorLabel;
        }

        public final void setSourceConnectorLabel(String sourceConnectorLabel) {
            this.sourceConnectorLabel = sourceConnectorLabel;
        }

        @Override
        public final Builder sourceConnectorLabel(String sourceConnectorLabel) {
            this.sourceConnectorLabel = sourceConnectorLabel;
            return this;
        }

        public final String getDestinationConnectorType() {
            return this.destinationConnectorType;
        }

        public final void setDestinationConnectorType(String destinationConnectorType) {
            this.destinationConnectorType = destinationConnectorType;
        }

        @Override
        public final Builder destinationConnectorType(String destinationConnectorType) {
            this.destinationConnectorType = destinationConnectorType;
            return this;
        }

        @Override
        public final Builder destinationConnectorType(ConnectorType destinationConnectorType) {
            this.destinationConnectorType(destinationConnectorType == null ? null : destinationConnectorType.toString());
            return this;
        }

        public final String getDestinationConnectorLabel() {
            return this.destinationConnectorLabel;
        }

        public final void setDestinationConnectorLabel(String destinationConnectorLabel) {
            this.destinationConnectorLabel = destinationConnectorLabel;
        }

        @Override
        public final Builder destinationConnectorLabel(String destinationConnectorLabel) {
            this.destinationConnectorLabel = destinationConnectorLabel;
            return this;
        }

        public final String getTriggerType() {
            return this.triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExecutionDetails.Builder getLastRunExecutionDetails() {
            return this.lastRunExecutionDetails != null ? this.lastRunExecutionDetails.toBuilder() : null;
        }

        public final void setLastRunExecutionDetails(ExecutionDetails.BuilderImpl lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails != null ? lastRunExecutionDetails.build() : null;
        }

        @Override
        public final Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails;
            return this;
        }

        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowDefinition> {
        public Builder flowArn(String var1);

        public Builder description(String var1);

        public Builder flowName(String var1);

        public Builder flowStatus(String var1);

        public Builder flowStatus(FlowStatus var1);

        public Builder sourceConnectorType(String var1);

        public Builder sourceConnectorType(ConnectorType var1);

        public Builder sourceConnectorLabel(String var1);

        public Builder destinationConnectorType(String var1);

        public Builder destinationConnectorType(ConnectorType var1);

        public Builder destinationConnectorLabel(String var1);

        public Builder triggerType(String var1);

        public Builder triggerType(TriggerType var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder lastRunExecutionDetails(ExecutionDetails var1);

        default public Builder lastRunExecutionDetails(Consumer<ExecutionDetails.Builder> lastRunExecutionDetails) {
            return this.lastRunExecutionDetails((ExecutionDetails)((ExecutionDetails.Builder)ExecutionDetails.builder().applyMutation(lastRunExecutionDetails)).build());
        }
    }
}

