/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appfabric.model.AppFabricResponse;
import software.amazon.awssdk.services.appfabric.model.IngestionListCopier;
import software.amazon.awssdk.services.appfabric.model.IngestionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestionsResponse
extends AppFabricResponse
implements ToCopyableBuilder<Builder, ListIngestionsResponse> {
    private static final SdkField<List<IngestionSummary>> INGESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ingestions").getter(ListIngestionsResponse.getter(ListIngestionsResponse::ingestions)).setter(ListIngestionsResponse.setter(Builder::ingestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestionsResponse.getter(ListIngestionsResponse::nextToken)).setter(ListIngestionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngestionsResponse.memberNameToFieldInitializer();
    private final List<IngestionSummary> ingestions;
    private final String nextToken;

    private ListIngestionsResponse(BuilderImpl builder) {
        super(builder);
        this.ingestions = builder.ingestions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIngestions() {
        return this.ingestions != null && !(this.ingestions instanceof SdkAutoConstructList);
    }

    public final List<IngestionSummary> ingestions() {
        return this.ingestions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestions() ? this.ingestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionsResponse)) {
            return false;
        }
        ListIngestionsResponse other = (ListIngestionsResponse)((Object)obj);
        return this.hasIngestions() == other.hasIngestions() && Objects.equals(this.ingestions(), other.ingestions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestionsResponse").add("Ingestions", this.hasIngestions() ? this.ingestions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ingestions": {
                return Optional.ofNullable(clazz.cast(this.ingestions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ingestions", INGESTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionsResponse, T> g) {
        return obj -> g.apply((ListIngestionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricResponse.BuilderImpl
    implements Builder {
        private List<IngestionSummary> ingestions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionsResponse model) {
            super(model);
            this.ingestions(model.ingestions);
            this.nextToken(model.nextToken);
        }

        public final List<IngestionSummary.Builder> getIngestions() {
            List<IngestionSummary.Builder> result = IngestionListCopier.copyToBuilder(this.ingestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestions(Collection<IngestionSummary.BuilderImpl> ingestions) {
            this.ingestions = IngestionListCopier.copyFromBuilder(ingestions);
        }

        @Override
        public final Builder ingestions(Collection<IngestionSummary> ingestions) {
            this.ingestions = IngestionListCopier.copy(ingestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestions(IngestionSummary ... ingestions) {
            this.ingestions(Arrays.asList(ingestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestions(Consumer<IngestionSummary.Builder> ... ingestions) {
            this.ingestions(Stream.of(ingestions).map(c -> (IngestionSummary)((IngestionSummary.Builder)IngestionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngestionsResponse build() {
            return new ListIngestionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestionsResponse> {
        public Builder ingestions(Collection<IngestionSummary> var1);

        public Builder ingestions(IngestionSummary ... var1);

        public Builder ingestions(Consumer<IngestionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

