/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricAsyncClient;
import software.amazon.awssdk.services.appfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse;

public class ListAppAuthorizationsPublisher
implements SdkPublisher<ListAppAuthorizationsResponse> {
    private final AppFabricAsyncClient client;
    private final ListAppAuthorizationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppAuthorizationsPublisher(AppFabricAsyncClient client, ListAppAuthorizationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppAuthorizationsPublisher(AppFabricAsyncClient client, ListAppAuthorizationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppAuthorizationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppAuthorizationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppAuthorizationSummary> appAuthorizationSummaryList() {
        Function<ListAppAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appAuthorizationSummaryList() != null) {
                return response.appAuthorizationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppAuthorizationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppAuthorizationsResponseFetcher
    implements AsyncPageFetcher<ListAppAuthorizationsResponse> {
        private ListAppAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppAuthorizationsResponse> nextPage(ListAppAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return ListAppAuthorizationsPublisher.this.client.listAppAuthorizations(ListAppAuthorizationsPublisher.this.firstRequest);
            }
            return ListAppAuthorizationsPublisher.this.client.listAppAuthorizations((ListAppAuthorizationsRequest)((Object)ListAppAuthorizationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

