/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletionProtectionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeletionProtectionSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DeletionProtectionSettings.getter(DeletionProtectionSettings::enabled)).setter(DeletionProtectionSettings.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> PROTECTION_PERIOD_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProtectionPeriodInMinutes").getter(DeletionProtectionSettings.getter(DeletionProtectionSettings::protectionPeriodInMinutes)).setter(DeletionProtectionSettings.setter(Builder::protectionPeriodInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPeriodInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, PROTECTION_PERIOD_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeletionProtectionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer protectionPeriodInMinutes;

    private DeletionProtectionSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.protectionPeriodInMinutes = builder.protectionPeriodInMinutes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer protectionPeriodInMinutes() {
        return this.protectionPeriodInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionPeriodInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionProtectionSettings)) {
            return false;
        }
        DeletionProtectionSettings other = (DeletionProtectionSettings)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.protectionPeriodInMinutes(), other.protectionPeriodInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"DeletionProtectionSettings").add("Enabled", (Object)this.enabled()).add("ProtectionPeriodInMinutes", (Object)this.protectionPeriodInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ProtectionPeriodInMinutes": {
                return Optional.ofNullable(clazz.cast(this.protectionPeriodInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("ProtectionPeriodInMinutes", PROTECTION_PERIOD_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletionProtectionSettings, T> g) {
        return obj -> g.apply((DeletionProtectionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer protectionPeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionProtectionSettings model) {
            this.enabled(model.enabled);
            this.protectionPeriodInMinutes(model.protectionPeriodInMinutes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getProtectionPeriodInMinutes() {
            return this.protectionPeriodInMinutes;
        }

        public final void setProtectionPeriodInMinutes(Integer protectionPeriodInMinutes) {
            this.protectionPeriodInMinutes = protectionPeriodInMinutes;
        }

        @Override
        public final Builder protectionPeriodInMinutes(Integer protectionPeriodInMinutes) {
            this.protectionPeriodInMinutes = protectionPeriodInMinutes;
            return this;
        }

        public DeletionProtectionSettings build() {
            return new DeletionProtectionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeletionProtectionSettings> {
        public Builder enabled(Boolean var1);

        public Builder protectionPeriodInMinutes(Integer var1);
    }
}

