/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionInvocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionInvocation> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionIdentifier").getter(ActionInvocation.getter(ActionInvocation::extensionIdentifier)).setter(ActionInvocation.setter(Builder::extensionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionIdentifier").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(ActionInvocation.getter(ActionInvocation::actionName)).setter(ActionInvocation.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(ActionInvocation.getter(ActionInvocation::uri)).setter(ActionInvocation.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ActionInvocation.getter(ActionInvocation::roleArn)).setter(ActionInvocation.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ActionInvocation.getter(ActionInvocation::errorMessage)).setter(ActionInvocation.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ActionInvocation.getter(ActionInvocation::errorCode)).setter(ActionInvocation.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationId").getter(ActionInvocation.getter(ActionInvocation::invocationId)).setter(ActionInvocation.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD, ACTION_NAME_FIELD, URI_FIELD, ROLE_ARN_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, INVOCATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionInvocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String extensionIdentifier;
    private final String actionName;
    private final String uri;
    private final String roleArn;
    private final String errorMessage;
    private final String errorCode;
    private final String invocationId;

    private ActionInvocation(BuilderImpl builder) {
        this.extensionIdentifier = builder.extensionIdentifier;
        this.actionName = builder.actionName;
        this.uri = builder.uri;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.invocationId = builder.invocationId;
    }

    public final String extensionIdentifier() {
        return this.extensionIdentifier;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String uri() {
        return this.uri;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionInvocation)) {
            return false;
        }
        ActionInvocation other = (ActionInvocation)obj;
        return Objects.equals(this.extensionIdentifier(), other.extensionIdentifier()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.invocationId(), other.invocationId());
    }

    public final String toString() {
        return ToString.builder((String)"ActionInvocation").add("ExtensionIdentifier", (Object)this.extensionIdentifier()).add("ActionName", (Object)this.actionName()).add("Uri", (Object)this.uri()).add("RoleArn", (Object)this.roleArn()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("InvocationId", (Object)this.invocationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.extensionIdentifier()));
            }
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "InvocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExtensionIdentifier", EXTENSION_IDENTIFIER_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("Uri", URI_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("InvocationId", INVOCATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionInvocation, T> g) {
        return obj -> g.apply((ActionInvocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String extensionIdentifier;
        private String actionName;
        private String uri;
        private String roleArn;
        private String errorMessage;
        private String errorCode;
        private String invocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionInvocation model) {
            this.extensionIdentifier(model.extensionIdentifier);
            this.actionName(model.actionName);
            this.uri(model.uri);
            this.roleArn(model.roleArn);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.invocationId(model.invocationId);
        }

        public final String getExtensionIdentifier() {
            return this.extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public ActionInvocation build() {
            return new ActionInvocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionInvocation> {
        public Builder extensionIdentifier(String var1);

        public Builder actionName(String var1);

        public Builder uri(String var1);

        public Builder roleArn(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder invocationId(String var1);
    }
}

