/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.ParameterValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExtensionAssociationResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, GetExtensionAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::id)).setter(GetExtensionAssociationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> EXTENSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionArn").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::extensionArn)).setter(GetExtensionAssociationResponse.setter(Builder::extensionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::resourceArn)).setter(GetExtensionAssociationResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::arn)).setter(GetExtensionAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::parameters)).setter(GetExtensionAssociationResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExtensionVersionNumber").getter(GetExtensionAssociationResponse.getter(GetExtensionAssociationResponse::extensionVersionNumber)).setter(GetExtensionAssociationResponse.setter(Builder::extensionVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTENSION_ARN_FIELD, RESOURCE_ARN_FIELD, ARN_FIELD, PARAMETERS_FIELD, EXTENSION_VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExtensionAssociationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String extensionArn;
    private final String resourceArn;
    private final String arn;
    private final Map<String, String> parameters;
    private final Integer extensionVersionNumber;

    private GetExtensionAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.extensionArn = builder.extensionArn;
        this.resourceArn = builder.resourceArn;
        this.arn = builder.arn;
        this.parameters = builder.parameters;
        this.extensionVersionNumber = builder.extensionVersionNumber;
    }

    public final String id() {
        return this.id;
    }

    public final String extensionArn() {
        return this.extensionArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final Integer extensionVersionNumber() {
        return this.extensionVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionVersionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExtensionAssociationResponse)) {
            return false;
        }
        GetExtensionAssociationResponse other = (GetExtensionAssociationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.extensionArn(), other.extensionArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.arn(), other.arn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.extensionVersionNumber(), other.extensionVersionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetExtensionAssociationResponse").add("Id", (Object)this.id()).add("ExtensionArn", (Object)this.extensionArn()).add("ResourceArn", (Object)this.resourceArn()).add("Arn", (Object)this.arn()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ExtensionVersionNumber", (Object)this.extensionVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ExtensionArn": {
                return Optional.ofNullable(clazz.cast(this.extensionArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ExtensionVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.extensionVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ExtensionArn", EXTENSION_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ExtensionVersionNumber", EXTENSION_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExtensionAssociationResponse, T> g) {
        return obj -> g.apply((GetExtensionAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String id;
        private String extensionArn;
        private String resourceArn;
        private String arn;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer extensionVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExtensionAssociationResponse model) {
            super(model);
            this.id(model.id);
            this.extensionArn(model.extensionArn);
            this.resourceArn(model.resourceArn);
            this.arn(model.arn);
            this.parameters(model.parameters);
            this.extensionVersionNumber(model.extensionVersionNumber);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExtensionArn() {
            return this.extensionArn;
        }

        public final void setExtensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
        }

        @Override
        public final Builder extensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return this.extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        @Override
        public GetExtensionAssociationResponse build() {
            return new GetExtensionAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExtensionAssociationResponse> {
        public Builder id(String var1);

        public Builder extensionArn(String var1);

        public Builder resourceArn(String var1);

        public Builder arn(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder extensionVersionNumber(Integer var1);
    }
}

