/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidatorType {
    JSON_SCHEMA("JSON_SCHEMA"),
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidatorType> VALUE_MAP;
    private final String value;

    private ValidatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidatorType> knownValues() {
        EnumSet<ValidatorType> knownValues = EnumSet.allOf(ValidatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidatorType.class, ValidatorType::toString);
    }
}

