/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.Action;
import software.amazon.awssdk.services.appconfig.model.ActionPoint;
import software.amazon.awssdk.services.appconfig.model.ActionsMapCopier;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.Parameter;
import software.amazon.awssdk.services.appconfig.model.ParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExtensionRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, UpdateExtensionRequest> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionIdentifier").getter(UpdateExtensionRequest.getter(UpdateExtensionRequest::extensionIdentifier)).setter(UpdateExtensionRequest.setter(Builder::extensionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ExtensionIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateExtensionRequest.getter(UpdateExtensionRequest::description)).setter(UpdateExtensionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, List<Action>>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Actions").getter(UpdateExtensionRequest.getter(UpdateExtensionRequest::actionsAsStrings)).setter(UpdateExtensionRequest.setter(Builder::actionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(UpdateExtensionRequest.getter(UpdateExtensionRequest::parameters)).setter(UpdateExtensionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionNumber").getter(UpdateExtensionRequest.getter(UpdateExtensionRequest::versionNumber)).setter(UpdateExtensionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, ACTIONS_FIELD, PARAMETERS_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateExtensionRequest.memberNameToFieldInitializer();
    private final String extensionIdentifier;
    private final String description;
    private final Map<String, List<Action>> actions;
    private final Map<String, Parameter> parameters;
    private final Integer versionNumber;

    private UpdateExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.extensionIdentifier = builder.extensionIdentifier;
        this.description = builder.description;
        this.actions = builder.actions;
        this.parameters = builder.parameters;
        this.versionNumber = builder.versionNumber;
    }

    public final String extensionIdentifier() {
        return this.extensionIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final Map<ActionPoint, List<Action>> actions() {
        return ActionsMapCopier.copyStringToEnum(this.actions);
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<Action>> actionsAsStrings() {
        return this.actions;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Parameter> parameters() {
        return this.parameters;
    }

    public final Integer versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExtensionRequest)) {
            return false;
        }
        UpdateExtensionRequest other = (UpdateExtensionRequest)((Object)obj);
        return Objects.equals(this.extensionIdentifier(), other.extensionIdentifier()) && Objects.equals(this.description(), other.description()) && this.hasActions() == other.hasActions() && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateExtensionRequest").add("ExtensionIdentifier", (Object)this.extensionIdentifier()).add("Description", (Object)this.description()).add("Actions", this.hasActions() ? this.actionsAsStrings() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.extensionIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExtensionIdentifier", EXTENSION_IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExtensionRequest, T> g) {
        return obj -> g.apply((UpdateExtensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String extensionIdentifier;
        private String description;
        private Map<String, List<Action>> actions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Parameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExtensionRequest model) {
            super(model);
            this.extensionIdentifier(model.extensionIdentifier);
            this.description(model.description);
            this.actionsWithStrings(model.actions);
            this.parameters(model.parameters);
            this.versionNumber(model.versionNumber);
        }

        public final String getExtensionIdentifier() {
            return this.extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, List<Action.Builder>> getActions() {
            Map<String, List<Action.Builder>> result = ActionsMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ? extends Collection<Action.BuilderImpl>> actions) {
            this.actions = ActionsMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actionsWithStrings(Map<String, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copy(actions);
            return this;
        }

        @Override
        public final Builder actions(Map<ActionPoint, ? extends Collection<Action>> actions) {
            this.actions = ActionsMapCopier.copyEnumToString(actions);
            return this;
        }

        public final Map<String, Parameter.Builder> getParameters() {
            Map<String, Parameter.Builder> result = ParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, Parameter.BuilderImpl> parameters) {
            this.parameters = ParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, Parameter> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
            return this;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExtensionRequest build() {
            return new UpdateExtensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateExtensionRequest> {
        public Builder extensionIdentifier(String var1);

        public Builder description(String var1);

        public Builder actionsWithStrings(Map<String, ? extends Collection<Action>> var1);

        public Builder actions(Map<ActionPoint, ? extends Collection<Action>> var1);

        public Builder parameters(Map<String, Parameter> var1);

        public Builder versionNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

