/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListRoutingRulesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListRoutingRulesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRule;

public class ListRoutingRulesPublisher
implements SdkPublisher<ListRoutingRulesResponse> {
    private final ApiGatewayV2AsyncClient client;
    private final ListRoutingRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoutingRulesPublisher(ApiGatewayV2AsyncClient client, ListRoutingRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoutingRulesPublisher(ApiGatewayV2AsyncClient client, ListRoutingRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoutingRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoutingRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoutingRule> routingRules() {
        Function<ListRoutingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingRules() != null) {
                return response.routingRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoutingRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoutingRulesResponseFetcher
    implements AsyncPageFetcher<ListRoutingRulesResponse> {
        private ListRoutingRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoutingRulesResponse> nextPage(ListRoutingRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingRulesPublisher.this.client.listRoutingRules(ListRoutingRulesPublisher.this.firstRequest);
            }
            return ListRoutingRulesPublisher.this.client.listRoutingRules((ListRoutingRulesRequest)((Object)ListRoutingRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

