/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.EndpointDisplayContentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.RestEndpointIdentifier;
import software.amazon.awssdk.services.apigatewayv2.model.Status;
import software.amazon.awssdk.services.apigatewayv2.model.StatusException;
import software.amazon.awssdk.services.apigatewayv2.model.TryItState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProductRestEndpointPageResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, GetProductRestEndpointPageResponse> {
    private static final SdkField<EndpointDisplayContentResponse> DISPLAY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayContent").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::displayContent)).setter(GetProductRestEndpointPageResponse.setter(Builder::displayContent)).constructor(EndpointDisplayContentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayContent").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::lastModified)).setter(GetProductRestEndpointPageResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductRestEndpointPageArn").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::productRestEndpointPageArn)).setter(GetProductRestEndpointPageResponse.setter(Builder::productRestEndpointPageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productRestEndpointPageArn").build()}).build();
    private static final SdkField<String> PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductRestEndpointPageId").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::productRestEndpointPageId)).setter(GetProductRestEndpointPageResponse.setter(Builder::productRestEndpointPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productRestEndpointPageId").build()}).build();
    private static final SdkField<String> RAW_DISPLAY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawDisplayContent").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::rawDisplayContent)).setter(GetProductRestEndpointPageResponse.setter(Builder::rawDisplayContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawDisplayContent").build()}).build();
    private static final SdkField<RestEndpointIdentifier> REST_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestEndpointIdentifier").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::restEndpointIdentifier)).setter(GetProductRestEndpointPageResponse.setter(Builder::restEndpointIdentifier)).constructor(RestEndpointIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restEndpointIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::statusAsString)).setter(GetProductRestEndpointPageResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusException> STATUS_EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusException").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::statusException)).setter(GetProductRestEndpointPageResponse.setter(Builder::statusException)).constructor(StatusException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusException").build()}).build();
    private static final SdkField<String> TRY_IT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TryItState").getter(GetProductRestEndpointPageResponse.getter(GetProductRestEndpointPageResponse::tryItStateAsString)).setter(GetProductRestEndpointPageResponse.setter(Builder::tryItState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tryItState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_CONTENT_FIELD, LAST_MODIFIED_FIELD, PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD, PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD, RAW_DISPLAY_CONTENT_FIELD, REST_ENDPOINT_IDENTIFIER_FIELD, STATUS_FIELD, STATUS_EXCEPTION_FIELD, TRY_IT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProductRestEndpointPageResponse.memberNameToFieldInitializer();
    private final EndpointDisplayContentResponse displayContent;
    private final Instant lastModified;
    private final String productRestEndpointPageArn;
    private final String productRestEndpointPageId;
    private final String rawDisplayContent;
    private final RestEndpointIdentifier restEndpointIdentifier;
    private final String status;
    private final StatusException statusException;
    private final String tryItState;

    private GetProductRestEndpointPageResponse(BuilderImpl builder) {
        super(builder);
        this.displayContent = builder.displayContent;
        this.lastModified = builder.lastModified;
        this.productRestEndpointPageArn = builder.productRestEndpointPageArn;
        this.productRestEndpointPageId = builder.productRestEndpointPageId;
        this.rawDisplayContent = builder.rawDisplayContent;
        this.restEndpointIdentifier = builder.restEndpointIdentifier;
        this.status = builder.status;
        this.statusException = builder.statusException;
        this.tryItState = builder.tryItState;
    }

    public final EndpointDisplayContentResponse displayContent() {
        return this.displayContent;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String productRestEndpointPageArn() {
        return this.productRestEndpointPageArn;
    }

    public final String productRestEndpointPageId() {
        return this.productRestEndpointPageId;
    }

    public final String rawDisplayContent() {
        return this.rawDisplayContent;
    }

    public final RestEndpointIdentifier restEndpointIdentifier() {
        return this.restEndpointIdentifier;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusException statusException() {
        return this.statusException;
    }

    public final TryItState tryItState() {
        return TryItState.fromValue(this.tryItState);
    }

    public final String tryItStateAsString() {
        return this.tryItState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.productRestEndpointPageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productRestEndpointPageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawDisplayContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.restEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusException());
        hashCode = 31 * hashCode + Objects.hashCode(this.tryItStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProductRestEndpointPageResponse)) {
            return false;
        }
        GetProductRestEndpointPageResponse other = (GetProductRestEndpointPageResponse)((Object)obj);
        return Objects.equals(this.displayContent(), other.displayContent()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.productRestEndpointPageArn(), other.productRestEndpointPageArn()) && Objects.equals(this.productRestEndpointPageId(), other.productRestEndpointPageId()) && Objects.equals(this.rawDisplayContent(), other.rawDisplayContent()) && Objects.equals(this.restEndpointIdentifier(), other.restEndpointIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusException(), other.statusException()) && Objects.equals(this.tryItStateAsString(), other.tryItStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetProductRestEndpointPageResponse").add("DisplayContent", (Object)this.displayContent()).add("LastModified", (Object)this.lastModified()).add("ProductRestEndpointPageArn", (Object)this.productRestEndpointPageArn()).add("ProductRestEndpointPageId", (Object)this.productRestEndpointPageId()).add("RawDisplayContent", (Object)this.rawDisplayContent()).add("RestEndpointIdentifier", (Object)this.restEndpointIdentifier()).add("Status", (Object)this.statusAsString()).add("StatusException", (Object)this.statusException()).add("TryItState", (Object)this.tryItStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayContent": {
                return Optional.ofNullable(clazz.cast(this.displayContent()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "ProductRestEndpointPageArn": {
                return Optional.ofNullable(clazz.cast(this.productRestEndpointPageArn()));
            }
            case "ProductRestEndpointPageId": {
                return Optional.ofNullable(clazz.cast(this.productRestEndpointPageId()));
            }
            case "RawDisplayContent": {
                return Optional.ofNullable(clazz.cast(this.rawDisplayContent()));
            }
            case "RestEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.restEndpointIdentifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusException": {
                return Optional.ofNullable(clazz.cast(this.statusException()));
            }
            case "TryItState": {
                return Optional.ofNullable(clazz.cast(this.tryItStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayContent", DISPLAY_CONTENT_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("productRestEndpointPageArn", PRODUCT_REST_ENDPOINT_PAGE_ARN_FIELD);
        map.put("productRestEndpointPageId", PRODUCT_REST_ENDPOINT_PAGE_ID_FIELD);
        map.put("rawDisplayContent", RAW_DISPLAY_CONTENT_FIELD);
        map.put("restEndpointIdentifier", REST_ENDPOINT_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusException", STATUS_EXCEPTION_FIELD);
        map.put("tryItState", TRY_IT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProductRestEndpointPageResponse, T> g) {
        return obj -> g.apply((GetProductRestEndpointPageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private EndpointDisplayContentResponse displayContent;
        private Instant lastModified;
        private String productRestEndpointPageArn;
        private String productRestEndpointPageId;
        private String rawDisplayContent;
        private RestEndpointIdentifier restEndpointIdentifier;
        private String status;
        private StatusException statusException;
        private String tryItState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProductRestEndpointPageResponse model) {
            super(model);
            this.displayContent(model.displayContent);
            this.lastModified(model.lastModified);
            this.productRestEndpointPageArn(model.productRestEndpointPageArn);
            this.productRestEndpointPageId(model.productRestEndpointPageId);
            this.rawDisplayContent(model.rawDisplayContent);
            this.restEndpointIdentifier(model.restEndpointIdentifier);
            this.status(model.status);
            this.statusException(model.statusException);
            this.tryItState(model.tryItState);
        }

        public final EndpointDisplayContentResponse.Builder getDisplayContent() {
            return this.displayContent != null ? this.displayContent.toBuilder() : null;
        }

        public final void setDisplayContent(EndpointDisplayContentResponse.BuilderImpl displayContent) {
            this.displayContent = displayContent != null ? displayContent.build() : null;
        }

        @Override
        public final Builder displayContent(EndpointDisplayContentResponse displayContent) {
            this.displayContent = displayContent;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getProductRestEndpointPageArn() {
            return this.productRestEndpointPageArn;
        }

        public final void setProductRestEndpointPageArn(String productRestEndpointPageArn) {
            this.productRestEndpointPageArn = productRestEndpointPageArn;
        }

        @Override
        public final Builder productRestEndpointPageArn(String productRestEndpointPageArn) {
            this.productRestEndpointPageArn = productRestEndpointPageArn;
            return this;
        }

        public final String getProductRestEndpointPageId() {
            return this.productRestEndpointPageId;
        }

        public final void setProductRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
        }

        @Override
        public final Builder productRestEndpointPageId(String productRestEndpointPageId) {
            this.productRestEndpointPageId = productRestEndpointPageId;
            return this;
        }

        public final String getRawDisplayContent() {
            return this.rawDisplayContent;
        }

        public final void setRawDisplayContent(String rawDisplayContent) {
            this.rawDisplayContent = rawDisplayContent;
        }

        @Override
        public final Builder rawDisplayContent(String rawDisplayContent) {
            this.rawDisplayContent = rawDisplayContent;
            return this;
        }

        public final RestEndpointIdentifier.Builder getRestEndpointIdentifier() {
            return this.restEndpointIdentifier != null ? this.restEndpointIdentifier.toBuilder() : null;
        }

        public final void setRestEndpointIdentifier(RestEndpointIdentifier.BuilderImpl restEndpointIdentifier) {
            this.restEndpointIdentifier = restEndpointIdentifier != null ? restEndpointIdentifier.build() : null;
        }

        @Override
        public final Builder restEndpointIdentifier(RestEndpointIdentifier restEndpointIdentifier) {
            this.restEndpointIdentifier = restEndpointIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusException.Builder getStatusException() {
            return this.statusException != null ? this.statusException.toBuilder() : null;
        }

        public final void setStatusException(StatusException.BuilderImpl statusException) {
            this.statusException = statusException != null ? statusException.build() : null;
        }

        @Override
        public final Builder statusException(StatusException statusException) {
            this.statusException = statusException;
            return this;
        }

        public final String getTryItState() {
            return this.tryItState;
        }

        public final void setTryItState(String tryItState) {
            this.tryItState = tryItState;
        }

        @Override
        public final Builder tryItState(String tryItState) {
            this.tryItState = tryItState;
            return this;
        }

        @Override
        public final Builder tryItState(TryItState tryItState) {
            this.tryItState(tryItState == null ? null : tryItState.toString());
            return this;
        }

        @Override
        public GetProductRestEndpointPageResponse build() {
            return new GetProductRestEndpointPageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProductRestEndpointPageResponse> {
        public Builder displayContent(EndpointDisplayContentResponse var1);

        default public Builder displayContent(Consumer<EndpointDisplayContentResponse.Builder> displayContent) {
            return this.displayContent((EndpointDisplayContentResponse)((EndpointDisplayContentResponse.Builder)EndpointDisplayContentResponse.builder().applyMutation(displayContent)).build());
        }

        public Builder lastModified(Instant var1);

        public Builder productRestEndpointPageArn(String var1);

        public Builder productRestEndpointPageId(String var1);

        public Builder rawDisplayContent(String var1);

        public Builder restEndpointIdentifier(RestEndpointIdentifier var1);

        default public Builder restEndpointIdentifier(Consumer<RestEndpointIdentifier.Builder> restEndpointIdentifier) {
            return this.restEndpointIdentifier((RestEndpointIdentifier)((RestEndpointIdentifier.Builder)RestEndpointIdentifier.builder().applyMutation(restEndpointIdentifier)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusException(StatusException var1);

        default public Builder statusException(Consumer<StatusException.Builder> statusException) {
            return this.statusException((StatusException)((StatusException.Builder)StatusException.builder().applyMutation(statusException)).build());
        }

        public Builder tryItState(String var1);

        public Builder tryItState(TryItState var1);
    }
}

