/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoConfig> {
    private static final SdkField<String> APP_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppClientId").getter(CognitoConfig.getter(CognitoConfig::appClientId)).setter(CognitoConfig.setter(Builder::appClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appClientId").build()}).build();
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolArn").getter(CognitoConfig.getter(CognitoConfig::userPoolArn)).setter(CognitoConfig.setter(Builder::userPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolArn").build()}).build();
    private static final SdkField<String> USER_POOL_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolDomain").getter(CognitoConfig.getter(CognitoConfig::userPoolDomain)).setter(CognitoConfig.setter(Builder::userPoolDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_CLIENT_ID_FIELD, USER_POOL_ARN_FIELD, USER_POOL_DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CognitoConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appClientId;
    private final String userPoolArn;
    private final String userPoolDomain;

    private CognitoConfig(BuilderImpl builder) {
        this.appClientId = builder.appClientId;
        this.userPoolArn = builder.userPoolArn;
        this.userPoolDomain = builder.userPoolDomain;
    }

    public final String appClientId() {
        return this.appClientId;
    }

    public final String userPoolArn() {
        return this.userPoolArn;
    }

    public final String userPoolDomain() {
        return this.userPoolDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoConfig)) {
            return false;
        }
        CognitoConfig other = (CognitoConfig)obj;
        return Objects.equals(this.appClientId(), other.appClientId()) && Objects.equals(this.userPoolArn(), other.userPoolArn()) && Objects.equals(this.userPoolDomain(), other.userPoolDomain());
    }

    public final String toString() {
        return ToString.builder((String)"CognitoConfig").add("AppClientId", (Object)this.appClientId()).add("UserPoolArn", (Object)this.userPoolArn()).add("UserPoolDomain", (Object)this.userPoolDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppClientId": {
                return Optional.ofNullable(clazz.cast(this.appClientId()));
            }
            case "UserPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "UserPoolDomain": {
                return Optional.ofNullable(clazz.cast(this.userPoolDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appClientId", APP_CLIENT_ID_FIELD);
        map.put("userPoolArn", USER_POOL_ARN_FIELD);
        map.put("userPoolDomain", USER_POOL_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CognitoConfig, T> g) {
        return obj -> g.apply((CognitoConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appClientId;
        private String userPoolArn;
        private String userPoolDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoConfig model) {
            this.appClientId(model.appClientId);
            this.userPoolArn(model.userPoolArn);
            this.userPoolDomain(model.userPoolDomain);
        }

        public final String getAppClientId() {
            return this.appClientId;
        }

        public final void setAppClientId(String appClientId) {
            this.appClientId = appClientId;
        }

        @Override
        public final Builder appClientId(String appClientId) {
            this.appClientId = appClientId;
            return this;
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final String getUserPoolDomain() {
            return this.userPoolDomain;
        }

        public final void setUserPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
        }

        @Override
        public final Builder userPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
            return this;
        }

        public CognitoConfig build() {
            return new CognitoConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoConfig> {
        public Builder appClientId(String var1);

        public Builder userPoolArn(String var1);

        public Builder userPoolDomain(String var1);
    }
}

