/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.Cors;
import software.amazon.awssdk.services.apigatewayv2.model.IpAddressType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(UpdateApiRequest.getter(UpdateApiRequest::apiId)).setter(UpdateApiRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKeySelectionExpression").getter(UpdateApiRequest.getter(UpdateApiRequest::apiKeySelectionExpression)).setter(UpdateApiRequest.setter(Builder::apiKeySelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build()}).build();
    private static final SdkField<Cors> CORS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CorsConfiguration").getter(UpdateApiRequest.getter(UpdateApiRequest::corsConfiguration)).setter(UpdateApiRequest.setter(Builder::corsConfiguration)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("corsConfiguration").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialsArn").getter(UpdateApiRequest.getter(UpdateApiRequest::credentialsArn)).setter(UpdateApiRequest.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApiRequest.getter(UpdateApiRequest::description)).setter(UpdateApiRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableSchemaValidation").getter(UpdateApiRequest.getter(UpdateApiRequest::disableSchemaValidation)).setter(UpdateApiRequest.setter(Builder::disableSchemaValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build()}).build();
    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableExecuteApiEndpoint").getter(UpdateApiRequest.getter(UpdateApiRequest::disableExecuteApiEndpoint)).setter(UpdateApiRequest.setter(Builder::disableExecuteApiEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(UpdateApiRequest.getter(UpdateApiRequest::ipAddressTypeAsString)).setter(UpdateApiRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateApiRequest.getter(UpdateApiRequest::name)).setter(UpdateApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteKey").getter(UpdateApiRequest.getter(UpdateApiRequest::routeKey)).setter(UpdateApiRequest.setter(Builder::routeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()}).build();
    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteSelectionExpression").getter(UpdateApiRequest.getter(UpdateApiRequest::routeSelectionExpression)).setter(UpdateApiRequest.setter(Builder::routeSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(UpdateApiRequest.getter(UpdateApiRequest::target)).setter(UpdateApiRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(UpdateApiRequest.getter(UpdateApiRequest::version)).setter(UpdateApiRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, API_KEY_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, DISABLE_EXECUTE_API_ENDPOINT_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, ROUTE_KEY_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApiRequest.memberNameToFieldInitializer();
    private final String apiId;
    private final String apiKeySelectionExpression;
    private final Cors corsConfiguration;
    private final String credentialsArn;
    private final String description;
    private final Boolean disableSchemaValidation;
    private final Boolean disableExecuteApiEndpoint;
    private final String ipAddressType;
    private final String name;
    private final String routeKey;
    private final String routeSelectionExpression;
    private final String target;
    private final String version;

    private UpdateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.routeKey = builder.routeKey;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.target = builder.target;
        this.version = builder.version;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String apiKeySelectionExpression() {
        return this.apiKeySelectionExpression;
    }

    public final Cors corsConfiguration() {
        return this.corsConfiguration;
    }

    public final String credentialsArn() {
        return this.credentialsArn;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean disableSchemaValidation() {
        return this.disableSchemaValidation;
    }

    public final Boolean disableExecuteApiEndpoint() {
        return this.disableExecuteApiEndpoint;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String name() {
        return this.name;
    }

    public final String routeKey() {
        return this.routeKey;
    }

    public final String routeSelectionExpression() {
        return this.routeSelectionExpression;
    }

    public final String target() {
        return this.target;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableExecuteApiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiRequest)) {
            return false;
        }
        UpdateApiRequest other = (UpdateApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiKeySelectionExpression(), other.apiKeySelectionExpression()) && Objects.equals(this.corsConfiguration(), other.corsConfiguration()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableSchemaValidation(), other.disableSchemaValidation()) && Objects.equals(this.disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routeKey(), other.routeKey()) && Objects.equals(this.routeSelectionExpression(), other.routeSelectionExpression()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApiRequest").add("ApiId", (Object)this.apiId()).add("ApiKeySelectionExpression", (Object)this.apiKeySelectionExpression()).add("CorsConfiguration", (Object)this.corsConfiguration()).add("CredentialsArn", (Object)this.credentialsArn()).add("Description", (Object)this.description()).add("DisableSchemaValidation", (Object)this.disableSchemaValidation()).add("DisableExecuteApiEndpoint", (Object)this.disableExecuteApiEndpoint()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Name", (Object)this.name()).add("RouteKey", (Object)this.routeKey()).add("RouteSelectionExpression", (Object)this.routeSelectionExpression()).add("Target", (Object)this.target()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiKeySelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiKeySelectionExpression()));
            }
            case "CorsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.corsConfiguration()));
            }
            case "CredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableSchemaValidation": {
                return Optional.ofNullable(clazz.cast(this.disableSchemaValidation()));
            }
            case "DisableExecuteApiEndpoint": {
                return Optional.ofNullable(clazz.cast(this.disableExecuteApiEndpoint()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RouteKey": {
                return Optional.ofNullable(clazz.cast(this.routeKey()));
            }
            case "RouteSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeSelectionExpression()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiId", API_ID_FIELD);
        map.put("apiKeySelectionExpression", API_KEY_SELECTION_EXPRESSION_FIELD);
        map.put("corsConfiguration", CORS_CONFIGURATION_FIELD);
        map.put("credentialsArn", CREDENTIALS_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("disableSchemaValidation", DISABLE_SCHEMA_VALIDATION_FIELD);
        map.put("disableExecuteApiEndpoint", DISABLE_EXECUTE_API_ENDPOINT_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("routeKey", ROUTE_KEY_FIELD);
        map.put("routeSelectionExpression", ROUTE_SELECTION_EXPRESSION_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiRequest, T> g) {
        return obj -> g.apply((UpdateApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String apiKeySelectionExpression;
        private Cors corsConfiguration;
        private String credentialsArn;
        private String description;
        private Boolean disableSchemaValidation;
        private Boolean disableExecuteApiEndpoint;
        private String ipAddressType;
        private String name;
        private String routeKey;
        private String routeSelectionExpression;
        private String target;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.apiKeySelectionExpression(model.apiKeySelectionExpression);
            this.corsConfiguration(model.corsConfiguration);
            this.credentialsArn(model.credentialsArn);
            this.description(model.description);
            this.disableSchemaValidation(model.disableSchemaValidation);
            this.disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
            this.ipAddressType(model.ipAddressType);
            this.name(model.name);
            this.routeKey(model.routeKey);
            this.routeSelectionExpression(model.routeSelectionExpression);
            this.target(model.target);
            this.version(model.version);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final Cors.Builder getCorsConfiguration() {
            return this.corsConfiguration != null ? this.corsConfiguration.toBuilder() : null;
        }

        public final void setCorsConfiguration(Cors.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        @Override
        public final Builder corsConfiguration(Cors corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        @Override
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRouteKey() {
            return this.routeKey;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiRequest build() {
            return new UpdateApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApiRequest> {
        public Builder apiId(String var1);

        public Builder apiKeySelectionExpression(String var1);

        public Builder corsConfiguration(Cors var1);

        default public Builder corsConfiguration(Consumer<Cors.Builder> corsConfiguration) {
            return this.corsConfiguration((Cors)((Cors.Builder)Cors.builder().applyMutation(corsConfiguration)).build());
        }

        public Builder credentialsArn(String var1);

        public Builder description(String var1);

        public Builder disableSchemaValidation(Boolean var1);

        public Builder disableExecuteApiEndpoint(Boolean var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder name(String var1);

        public Builder routeKey(String var1);

        public Builder routeSelectionExpression(String var1);

        public Builder target(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

