/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentifierParts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentifierParts> {
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(IdentifierParts.getter(IdentifierParts::method)).setter(IdentifierParts.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(IdentifierParts.getter(IdentifierParts::path)).setter(IdentifierParts.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestApiId").getter(IdentifierParts.getter(IdentifierParts::restApiId)).setter(IdentifierParts.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(IdentifierParts.getter(IdentifierParts::stage)).setter(IdentifierParts.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD, PATH_FIELD, REST_API_ID_FIELD, STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentifierParts.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String method;
    private final String path;
    private final String restApiId;
    private final String stage;

    private IdentifierParts(BuilderImpl builder) {
        this.method = builder.method;
        this.path = builder.path;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    public final String method() {
        return this.method;
    }

    public final String path() {
        return this.path;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentifierParts)) {
            return false;
        }
        IdentifierParts other = (IdentifierParts)obj;
        return Objects.equals(this.method(), other.method()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder((String)"IdentifierParts").add("Method", (Object)this.method()).add("Path", (Object)this.path()).add("RestApiId", (Object)this.restApiId()).add("Stage", (Object)this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "RestApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("method", METHOD_FIELD);
        map.put("path", PATH_FIELD);
        map.put("restApiId", REST_API_ID_FIELD);
        map.put("stage", STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentifierParts, T> g) {
        return obj -> g.apply((IdentifierParts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String method;
        private String path;
        private String restApiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentifierParts model) {
            this.method(model.method);
            this.path(model.path);
            this.restApiId(model.restApiId);
            this.stage(model.stage);
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public IdentifierParts build() {
            return new IdentifierParts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentifierParts> {
        public Builder method(String var1);

        public Builder path(String var1);

        public Builder restApiId(String var1);

        public Builder stage(String var1);
    }
}

